/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.templates;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.templates.Locale;
import com.lightcrafts.templates.TemplateDatabaseListener;
import com.lightcrafts.templates.TemplateDeployer;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class TemplateDatabase {
    static final String CameraDefaultNamespace = "CameraDefault";
    static final String DefaultNamespace = Locale.LOCALE.get("DefaultTemplateNamespace");
    static File TemplateDir;
    private static LinkedList<TemplateDatabaseListener> listeners;
    private static Preferences Prefs;

    private TemplateDatabase() {
    }

    public static void addListener(TemplateDatabaseListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(TemplateDatabaseListener listener) {
        listeners.remove(listener);
    }

    public static void deployFactoryTemplates() {
        TemplateDeployer.deploy();
        TemplateDatabase.notifyListeners();
    }

    public static List<TemplateKey> getTemplateKeys() throws TemplateException {
        TemplateDatabase.checkTemplateDir();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    String name = file.getName().toLowerCase();
                    return name.endsWith(".lzt");
                }
                return false;
            }
        };
        File[] files = FileUtil.listFiles(TemplateDir, filter, false);
        if (files == null) {
            throw new TemplateException("Couldn't read Template names from " + TemplateDir.getAbsolutePath());
        }
        ArrayList<TemplateKey> keys = new ArrayList<TemplateKey>();
        for (File file : files) {
            TemplateKey key = new TemplateKey(file);
            keys.add(key);
        }
        Collections.sort(keys);
        return keys;
    }

    public static XmlDocument getTemplateDocument(TemplateKey key) throws TemplateException {
        try {
            TemplateDatabase.checkTemplateDir();
            File file = key.getFile();
            if (file == null) {
                throw new TemplateException("No Template named \"" + key + "\" exists in " + TemplateDir.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(file);
            XmlDocument doc = new XmlDocument(in);
            ((InputStream)in).close();
            return doc;
        }
        catch (XMLException e) {
            throw new TemplateException("Template \"" + key + "\" in " + TemplateDir.getAbsolutePath() + " is malformed: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TemplateException("Couldn't access Template \"" + key + "\" in " + TemplateDir.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    public static void addTemplateDocument(XmlDocument doc, TemplateKey key, boolean force) throws TemplateException {
        try {
            TemplateDatabase.checkTemplateDir();
            File file = key.getFile();
            if (file.exists() && !force) {
                throw new TemplateException("A Template named \"" + key + "\" already exists in " + TemplateDir.getAbsolutePath());
            }
            FileOutputStream out = new FileOutputStream(file);
            doc.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new TemplateException("Couldn't add Template \"" + key + "\" in " + TemplateDir.getAbsolutePath(), e);
        }
        TemplateDatabase.notifyListeners();
    }

    public static void removeTemplateDocument(TemplateKey key) throws TemplateException {
        TemplateDatabase.checkTemplateDir();
        File file = key.getFile();
        boolean deleted = file.delete();
        if (!deleted) {
            throw new TemplateException("Couldn't delete Template \"" + key + "\" in " + TemplateDir.getAbsolutePath());
        }
        TemplateDatabase.notifyListeners();
    }

    public static void setDefaultTemplate(ImageMetadata meta, TemplateKey key) throws TemplateException {
        String camera = meta.getCameraMake(true);
        if (camera != null) {
            if (key != null) {
                XmlDocument xml = TemplateDatabase.getTemplateDocument(key);
                TemplateKey defaultKey = new TemplateKey(CameraDefaultNamespace, camera);
                TemplateDatabase.addTemplateDocument(xml, defaultKey, true);
            } else {
                key = new TemplateKey(CameraDefaultNamespace, camera);
                TemplateDatabase.removeTemplateDocument(key);
            }
        }
    }

    public static TemplateKey getDefaultTemplate(ImageMetadata meta) throws TemplateException {
        String camera;
        boolean isRaw = meta.getImageType() instanceof RawImageType;
        if (isRaw && (camera = meta.getCameraMake(true)) != null) {
            TemplateKey key = new TemplateKey(CameraDefaultNamespace, camera);
            XmlDocument xml = null;
            try {
                xml = TemplateDatabase.getTemplateDocument(key);
            }
            catch (TemplateException e) {
                throw new TemplateException("Template error: " + e.getMessage(), e);
            }
            if (xml == null) {
                return TemplateDatabase.getDefaultFromPrefs(meta);
            }
            return key;
        }
        return null;
    }

    private static TemplateKey getDefaultFromPrefs(ImageMetadata meta) {
        String name;
        String camera = meta.getCameraMake(true);
        if (camera != null && (name = Prefs.get(camera, null)) != null) {
            XmlDocument xml = null;
            TemplateKey key = new TemplateKey(CameraDefaultNamespace, name);
            try {
                xml = TemplateDatabase.getTemplateDocument(key);
            }
            catch (TemplateException e) {
                System.err.println("Default template not found: " + e.getMessage());
            }
            if (xml == null) {
                Prefs.remove(camera);
                return null;
            }
            return key;
        }
        return null;
    }

    private static void notifyListeners() {
        for (TemplateDatabaseListener listener : listeners) {
            listener.templatesChanged();
        }
    }

    private static void checkTemplateDir() throws TemplateException {
        if (TemplateDir == null) {
            boolean success;
            TemplateDir = new File(Platform.getPlatform().getLightZoneDocumentsDirectory(), "Templates");
            if (!TemplateDir.isDirectory() && !(success = TemplateDir.mkdirs())) {
                String path = TemplateDir.getAbsolutePath();
                TemplateDir = null;
                throw new TemplateException("Couldn't initialize Template directory at " + path);
            }
            if (System.getProperty("lightcrafts.debug") == null && !TemplateDeployer.hasDeployed()) {
                TemplateDeployer.deploy();
            }
            TemplateDatabase.migratePrefsTemplates();
            TemplateDatabase.migrateTemplateFolders();
            TemplateDatabase.migrateTemplateNamespace();
        }
    }

    private static void migratePrefsTemplates() {
        try {
            List<String> names = TemplateDatabase.getPrefsTemplateNames();
            for (String name : names) {
                try {
                    XmlDocument doc = TemplateDatabase.getPrefsTemplateDocument(name);
                    TemplateKey newKey = new TemplateKey("", name);
                    TemplateDatabase.addTemplateDocument(doc, newKey, false);
                    TemplateDatabase.removePrefsTemplateDocument(name);
                    System.out.println("Migrated old-style template " + name);
                }
                catch (TemplateException e) {
                    System.err.println("Failed to migrate old-style template " + name);
                }
            }
        }
        catch (TemplateException e) {
            System.err.println("Couldn't access old-style templates");
        }
    }

    private static void migrateTemplateFolders() {
        File[] oldFiles;
        String oldPath;
        Platform.Type platform = Platform.getType();
        if (platform == Platform.Windows) {
            oldPath = "Application Data\\LightZone\\Templates";
        } else if (platform == Platform.Linux) {
            oldPath = "LightZone/Templates";
        } else {
            return;
        }
        String home = System.getProperty("user.home");
        File oldTemplateDir = new File(home, oldPath);
        if (oldTemplateDir.isDirectory() && (oldFiles = FileUtil.listFiles(oldTemplateDir)) != null) {
            boolean copySucceeded = true;
            for (File oldFile : oldFiles) {
                File newFile = new File(TemplateDir, oldFile.getName());
                try {
                    FileUtil.copyFile(oldFile, newFile);
                    System.out.println("Copied a template from " + oldFile + " to " + newFile);
                    boolean deleted = oldFile.delete();
                    if (deleted) {
                        System.out.println("Deleted an old template at " + oldFile);
                        continue;
                    }
                    System.out.println("Failed to delete an old template at " + oldFile);
                }
                catch (IOException e) {
                    System.out.println("Failed to migrate a template from " + oldFile + " to " + newFile + ": " + e.getClass().getName() + " " + e.getMessage());
                    copySucceeded = false;
                }
            }
            if (copySucceeded) {
                boolean deleted = oldTemplateDir.delete();
                if (deleted) {
                    System.out.println("Deleted old template folder " + oldTemplateDir.getAbsolutePath());
                } else {
                    System.out.println("Failed to delete old template folder " + oldTemplateDir.getAbsolutePath());
                }
            }
        }
    }

    private static void migrateTemplateNamespace() {
        try {
            List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
            for (TemplateKey key : keys) {
                String namespace = key.getNamespace();
                if (!namespace.equals("")) continue;
                try {
                    XmlDocument xml = TemplateDatabase.getTemplateDocument(key);
                    String name = key.getName();
                    TemplateKey newKey = new TemplateKey(DefaultNamespace, name);
                    TemplateDatabase.addTemplateDocument(xml, newKey, false);
                    TemplateDatabase.removeTemplateDocument(key);
                }
                catch (TemplateException e) {
                    System.out.println("Template migration failed for " + key);
                    e.printStackTrace();
                }
            }
        }
        catch (TemplateException e) {
            System.out.println("Failed to migrate template namespaces");
        }
    }

    private static List<String> getPrefsTemplateNames() throws TemplateException {
        try {
            String[] keys = Prefs.keys();
            ArrayList<String> names = new ArrayList<String>();
            for (String key : keys) {
                String name = TemplateDatabase.getNameFromPrefsKey(key);
                if (name == null) continue;
                names.add(name);
            }
            Collections.sort(names);
            return names;
        }
        catch (BackingStoreException e) {
            throw new TemplateException("Couldn't read template names", e);
        }
    }

    private static XmlDocument getPrefsTemplateDocument(String name) throws TemplateException {
        try {
            String key = TemplateDatabase.getPrefsKeyFromName(name);
            String text = Prefs.get(key, null);
            if (text == null) {
                throw new TemplateException("No template named \"" + name + "\"");
            }
            byte[] bytes = text.getBytes();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            XmlDocument doc = new XmlDocument(in);
            return doc;
        }
        catch (IOException e) {
            throw new TemplateException("Couldn't access template \"" + name + "\"", e);
        }
    }

    private static void removePrefsTemplateDocument(String name) {
        String key = TemplateDatabase.getPrefsKeyFromName(name);
        Prefs.remove(key);
    }

    private static String getPrefsKeyFromName(String name) {
        return "Template_" + name;
    }

    private static String getNameFromPrefsKey(String key) {
        if (key.startsWith("Template_")) {
            return key.replaceFirst("Template_", "");
        }
        return null;
    }

    static {
        listeners = new LinkedList();
        Prefs = Preferences.userNodeForPackage(TemplateDatabase.class);
    }

    public static class TemplateException
    extends Exception {
        TemplateException(String message) {
            super(message);
        }

        TemplateException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

