/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class ClearPrefsItem
extends PreferencesItem {
    private JButton clearButton = new JButton(Locale.LOCALE.get("ClearPrefsItemButton"));

    ClearPrefsItem(JTextArea help) {
        super(help);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClearPrefsItem.this.clearPrefs();
            }
        });
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("ClearPrefsItemLabel");
    }

    @Override
    public String getHelp(MouseEvent e) {
        return Locale.LOCALE.get("ClearPrefsItemHelp");
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public JComponent getComponent() {
        Box box = Box.createHorizontalBox();
        box.add(this.clearButton);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    @Override
    public void commit() {
    }

    @Override
    public void restore() {
    }

    private void clearPrefs() {
        JTextArea text = ClearPrefsItem.createText(Locale.LOCALE.get("ClearPrefsItemWarning1") + "\n\n" + Locale.LOCALE.get("ClearPrefsItemWarning2") + "\n\n" + Locale.LOCALE.get("ClearPrefsItemWarning3"));
        text.setBackground(new JPanel().getBackground());
        JButton help = new JButton(Locale.LOCALE.get("ClearPrefsItemHelpButton"));
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ClearPrefsItem.showHelpDialog();
            }
        });
        int option = JOptionPane.showOptionDialog(null, text, Locale.LOCALE.get("ClearPrefsDialogTitle"), 2, 2, null, new Object[]{help, Locale.LOCALE.get("ClearPrefsResetOption"), Locale.LOCALE.get("ClearPrefsDontResetOption")}, Locale.LOCALE.get("ClearPrefsDontResetOption"));
        if (option == 1) {
            boolean success = true;
            try {
                Preferences root = Preferences.userRoot();
                Preferences node = root.node("/com/lightcrafts");
                node.removeNode();
                node.flush();
            }
            catch (BackingStoreException e) {
                System.err.println("ClearPrefs failed to reset Preferences");
                ClearPrefsItem.showErrorDialog(e);
                success = false;
            }
            if (success) {
                ClearPrefsItem.showSuccessDialog();
                System.exit(0);
            }
        }
    }

    private static void showHelpDialog() {
        JTextArea text = ClearPrefsItem.createText(Locale.LOCALE.get("ClearPrefsBigHelpProlog") + "\n" + "\n" + "    " + Locale.LOCALE.get("ClearPrefsBigHelp1") + "\n" + "    " + Locale.LOCALE.get("ClearPrefsBigHelp2") + "\n" + "    " + Locale.LOCALE.get("ClearPrefsBigHelp3") + "\n" + "    " + Locale.LOCALE.get("ClearPrefsBigHelp4") + "\n" + "    " + Locale.LOCALE.get("ClearPrefsBigHelp5") + "\n" + "    " + Locale.LOCALE.get("ClearPrefsBigHelp6") + "\n" + "\n" + Locale.LOCALE.get("ClearPrefsBigHelpEpilog"));
        JOptionPane.showMessageDialog(null, text, Locale.LOCALE.get("ClearPrefsBigHelpTitle"), 1);
    }

    private static void showSuccessDialog() {
        JOptionPane.showOptionDialog(null, Locale.LOCALE.get("ClearPrefsSuccessMessage"), Locale.LOCALE.get("ClearPrefsSuccessTitle"), 0, 1, null, new Object[]{Locale.LOCALE.get("ClearPrefsSuccessButton")}, Locale.LOCALE.get("ClearPrefsSuccessButton"));
    }

    private static void showErrorDialog(Throwable t) {
        JOptionPane.showMessageDialog(null, Locale.LOCALE.get("ClearPrefsErrorMessage") + ": " + t.getClass().getName() + " " + t.getMessage(), Locale.LOCALE.get("ClearPrefsErrorTitle"), 0);
    }

    private static JTextArea createText(String message) {
        JTextArea text = TextAreaFactory.createTextArea(message, 40);
        text.setBackground(new JPanel().getBackground());
        return text;
    }
}

