/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ExceptionDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.splash.SplashImage;
import com.lightcrafts.splash.SplashWindow;
import com.lightcrafts.utils.ForkDaemon;
import com.lightcrafts.utils.Version;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.UIManager;

public class Launcher {
    public void init(String[] args) {
        try {
            this.setSystemProperties();
            this.enableTextAntiAliasing();
            this.showAppVersion();
            this.showJavaVersion();
            this.checkCpu();
            UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
            String licenseText = "Open Source";
            SplashImage splash = new SplashImage(SplashImage.getDefaultSplashText("Open Source"));
            SplashWindow.splash(splash);
            this.setColor();
            Application.setStartupProgress(splash.getStartupProgress());
            this.startForkDaemon();
            Application.main(args);
            SplashWindow.disposeSplash();
        }
        catch (Throwable t) {
            new ExceptionDialog().handle(t);
        }
    }

    protected void setSystemProperties() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }

    protected void enableTextAntiAliasing() {
        try {
            Class<?> clazz0 = Class.forName("sun.swing.SwingUtilities2");
            Method isLocalDisplay = clazz0.getMethod("isLocalDisplay", new Class[0]);
            Object lafCond = isLocalDisplay.invoke(null, new Object[0]);
            Class<?> clazz = Class.forName("sun.swing.SwingUtilities2$AATextInfo");
            Method method = clazz.getMethod("getAATextInfo", Boolean.TYPE);
            Object aaTextInfo = method.invoke(null, lafCond);
            Field field = clazz0.getField("AA_TEXT_PROPERTY_KEY");
            Object aaTextPropertyKey = field.get(null);
            UIManager.getDefaults().put(aaTextPropertyKey, aaTextInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    protected void showAppVersion() {
        System.out.println("This is " + Version.getApplicationName() + ' ' + Version.getVersionName() + ' ' + '(' + Version.getRevisionNumber() + ')');
    }

    protected String showJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        String javaArch = System.getProperty("os.arch");
        System.out.println("Running Java version " + javaVersion + ' ' + '(' + javaArch + ')');
        return javaVersion;
    }

    protected void checkCpu() {
    }

    protected void setColor() {
    }

    protected void startForkDaemon() throws IOException {
        ForkDaemon.start();
    }
}

