/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform;

import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.ProgressListener;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.swing.NoIcon;
import com.lightcrafts.utils.thread.CancelableThread;
import com.lightcrafts.utils.thread.CancelableThreadMonitor;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public final class DefaultProgressDialog
implements ProgressDialog {
    private JProgressBar m_progressBar = new JProgressBar();
    private CancelableThreadMonitor m_threadMonitor;

    public DefaultProgressDialog() {
        this.m_progressBar.putClientProperty("substancelaf.theme", LightZoneSkin.orangeTheme);
        this.m_progressBar.setBorder(null);
    }

    @Override
    public Throwable getThrown() {
        return this.m_threadMonitor.getThrown();
    }

    @Override
    public void incrementBy(final int delta) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DefaultProgressDialog.this.m_progressBar != null) {
                    DefaultProgressDialog.this.m_progressBar.setValue(DefaultProgressDialog.this.m_progressBar.getValue() + delta);
                }
            }
        });
    }

    @Override
    public void setIndeterminate(final boolean indeterminate) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DefaultProgressDialog.this.m_progressBar != null) {
                    DefaultProgressDialog.this.m_progressBar.setValue(DefaultProgressDialog.this.m_progressBar.getMaximum());
                    DefaultProgressDialog.this.m_progressBar.setIndeterminate(indeterminate);
                }
            }
        });
    }

    @Override
    public void setMaximum(final int maximum) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DefaultProgressDialog.this.m_progressBar != null) {
                    DefaultProgressDialog.this.m_progressBar.setMaximum(maximum);
                }
            }
        });
    }

    @Override
    public void setMinimum(final int minimum) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DefaultProgressDialog.this.m_progressBar != null) {
                    DefaultProgressDialog.this.m_progressBar.setMinimum(minimum);
                }
            }
        });
    }

    @Override
    public void showProgress(Frame parent, CancelableThread thread, String message, int minValue, int maxValue, boolean hasCancelButton) {
        ProgressListenerImpl pli = new ProgressListenerImpl(parent, thread, message, false, minValue, maxValue, hasCancelButton);
        pli.showAndWait();
    }

    @Override
    public void showProgress(Frame parent, CancelableThread thread, String message, boolean hasCancelButton) {
        ProgressListenerImpl pli = new ProgressListenerImpl(parent, thread, message, true, 0, 0, hasCancelButton);
        pli.showAndWait();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TestProgress");
        frame.setBounds(100, 100, 500, 300);
        frame.setVisible(true);
        DefaultProgressDialog dialog = new DefaultProgressDialog();
        TestThread t = new TestThread(dialog);
        dialog.showProgress(frame, t, "Working...", 0, 20, true);
        System.exit(0);
    }

    private static final class TestThread
    extends ProgressThread {
        TestThread(ProgressIndicator indicator) {
            super(indicator);
        }

        @Override
        public void run() {
            for (int i = 0; i < 20 && !this.isCanceled(); ++i) {
                System.out.println(i);
                this.getProgressIndicator().incrementBy(1);
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private final class ProgressListenerImpl
    implements CancelableThreadMonitor.Listener,
    ProgressListener {
        private JProgressDialog m_jProgressDialog;

        ProgressListenerImpl(Frame parent, CancelableThread thread, String message, boolean indeterminate, int minValue, int maxValue, boolean hasCancelButton) {
            this.init(parent, message, indeterminate, minValue, maxValue, hasCancelButton);
            DefaultProgressDialog.this.m_threadMonitor = new CancelableThreadMonitor(thread, this);
        }

        @Override
        public void progressCancelled() {
            DefaultProgressDialog.this.m_threadMonitor.requestCancel();
        }

        public void showAndWait() {
            DefaultProgressDialog.this.m_threadMonitor.start();
            this.m_jProgressDialog.setVisible(true);
        }

        @Override
        public void threadTerminated(CancelableThread t) {
            if (t != DefaultProgressDialog.this.m_threadMonitor.getMonitoredThread()) {
                throw new IllegalStateException();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressListenerImpl.this.m_jProgressDialog.dispose();
                }
            });
        }

        private void init(final Frame parent, final String message, final boolean indeterminate, final int minValue, final int maxValue, final boolean hasCancelButton) {
            if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProgressListenerImpl.this.init(parent, message, indeterminate, minValue, maxValue, hasCancelButton);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
                return;
            }
            if (indeterminate) {
                DefaultProgressDialog.this.m_progressBar.setIndeterminate(true);
            } else {
                DefaultProgressDialog.this.m_progressBar.setMaximum(maxValue);
                DefaultProgressDialog.this.m_progressBar.setMinimum(minValue);
            }
            this.m_jProgressDialog = new JProgressDialog(parent, message, hasCancelButton, this);
        }
    }

    private final class JProgressDialog
    extends JDialog {
        private static final int msgBarPadding = 5;

        JProgressDialog(Frame parent, String message, boolean hasCancelButton, final ProgressListener pl) {
            super(parent, Version.getApplicationName(), true);
            final JLabel messageLabel = new JLabel(message);
            this.setDefaultCloseOperation(0);
            JPanel layoutPanel = new JPanel(null){

                @Override
                public void doLayout() {
                    Dimension size = this.getSize();
                    messageLabel.setLocation(0, 0);
                    messageLabel.setSize(messageLabel.getPreferredSize());
                    Dimension mSize = messageLabel.getPreferredSize();
                    Dimension pSize = DefaultProgressDialog.this.m_progressBar.getPreferredSize();
                    DefaultProgressDialog.this.m_progressBar.setLocation(0, mSize.height + 5);
                    DefaultProgressDialog.this.m_progressBar.setSize(size.width, pSize.height);
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension mSize = messageLabel.getPreferredSize();
                    Dimension pSize = DefaultProgressDialog.this.m_progressBar.getPreferredSize();
                    return new Dimension(Math.max(mSize.width, pSize.width), mSize.height + pSize.height + 5);
                }
            };
            layoutPanel.add(messageLabel);
            layoutPanel.add(DefaultProgressDialog.this.m_progressBar);
            JButton cancelButton = new JButton("Cancel ");
            JOptionPane panel = new JOptionPane(layoutPanel, 1, 0, NoIcon.INSTANCE, new Object[]{cancelButton});
            if (hasCancelButton) {
                cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        messageLabel.setText("Cancelling...");
                        pl.progressCancelled();
                    }
                });
            } else {
                cancelButton.setEnabled(false);
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(panel);
            this.pack();
            this.setLocationRelativeTo(parent);
            this.setResizable(false);
        }

        @Override
        public void dispose() {
            if (DefaultProgressDialog.this.m_progressBar != null) {
                final Container barParent = DefaultProgressDialog.this.m_progressBar.getParent();
                if (barParent != null) {
                    final JProgressBar progreesBarCopy = DefaultProgressDialog.this.m_progressBar;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            barParent.remove(progreesBarCopy);
                        }
                    });
                }
                DefaultProgressDialog.this.m_progressBar = null;
            }
            super.dispose();
        }
    }
}

