/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform;

import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import com.lightcrafts.ui.toolkit.UICompliance;
import java.awt.Color;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class DefaultAlertDialog
implements AlertDialog {
    public static final DefaultAlertDialog INSTANCE = new DefaultAlertDialog();
    private static final Color BackgroundColor = LightZoneSkin.Colors.FrameBackground;

    @Override
    public int showAlert(Frame parentFrame, String msgText, String infoText, int alertType, String ... buttons) {
        return this.showAlert(parentFrame, msgText, infoText, alertType, -1, buttons);
    }

    @Override
    public int showAlert(Frame parentFrame, String msgText, String infoText, int alertType, int destructive, String ... buttons) {
        JTextArea msgArea;
        int optionType;
        int messageType;
        switch (alertType) {
            case 1: {
                messageType = 2;
                break;
            }
            case 2: {
                messageType = 0;
                break;
            }
            default: {
                messageType = -1;
            }
        }
        switch (buttons.length) {
            case 1: {
                optionType = -1;
                break;
            }
            case 2: {
                optionType = 2;
                break;
            }
            case 3: {
                optionType = 1;
                break;
            }
            default: {
                optionType = -1;
            }
        }
        Box msgBox = Box.createVerticalBox();
        if (msgText.contains("\n")) {
            msgArea = new JTextArea(msgText);
            msgArea.setLineWrap(false);
            msgArea.setEditable(false);
        } else {
            msgArea = TextAreaFactory.createTextArea(msgText, 30);
        }
        msgArea.setFont(msgArea.getFont().deriveFont(1));
        msgArea.setOpaque(false);
        msgArea.setBorder(null);
        msgBox.add(msgArea);
        if (infoText != null) {
            JTextArea infoArea;
            if (infoText.contains("\n")) {
                infoArea = new JTextArea(infoText);
                infoArea.setLineWrap(false);
                infoArea.setEditable(false);
            } else {
                infoArea = TextAreaFactory.createTextArea(infoText, 30);
            }
            infoArea.setOpaque(false);
            infoArea.setBorder(null);
            msgBox.add(Box.createVerticalStrut(6));
            msgBox.add(infoArea);
        }
        return UICompliance.showOptionDialog(parentFrame, msgBox, "Confirm", optionType, messageType, null, buttons, buttons[0], destructive);
    }

    private DefaultAlertDialog() {
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.antialiasing", "false");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.awt.textantialiasing", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("swing.aatext", "true");
        try {
            UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        int result = INSTANCE.showAlert(null, "LightZone file \"test.lzn\" can't locate its image file, \"oldImage.jpg\", but it found \"newImage.jpg\" instead.", "Is this right?", 2, "Use This", "Search", "Cancel");
        System.out.println("result=" + result);
        System.exit(0);
    }
}

