/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.LightnessLookupTable;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationImpl;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.utils.splines;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;

class ZoneOperationImpl
extends BlendedOperation
implements ZoneOperation {
    static final OperationType type = new OperationTypeImpl("Zone Mapper");
    private static final double weight = 10.0;
    private static final int order = 3;
    private double[][] controlPoints = new double[][]{{0.0, 0.0}, {1.0, 1.0}};
    private short[] tableData = new short[65536];
    private LookupTableJAI table = null;
    private double[][] curve = new double[256][2];
    private int scale = 1;
    double[] lastPoints = null;
    private short[] tableDataUShort = new short[65536];
    private byte[] tableDataByte = new byte[256];
    private LookupTableJAI byteLut = null;
    private LookupTableJAI ushortLut = null;

    ZoneOperationImpl(Rendering rendering) {
        super(rendering, type);
    }

    @Override
    public boolean neutralDefault() {
        return true;
    }

    public OperationImpl createInstance(Rendering rendering) {
        return new ZoneOperationImpl(rendering);
    }

    @Override
    public void setScale(int scale) {
        if (scale != 0 && scale != 1) {
            throw new IllegalArgumentException("setScale() only accepts RgbScale and LuminosityScale");
        }
        if (this.scale != scale) {
            this.scale = scale;
            this.table = null;
            this.settingsChanged();
        }
    }

    @Override
    public void setControlPoints(double[] points) {
        if (this.lastPoints != null && points.length == this.lastPoints.length) {
            boolean noChange = true;
            for (int i = 0; i < points.length; ++i) {
                if (points[i] == this.lastPoints[i]) continue;
                noChange = false;
                break;
            }
            if (noChange) {
                return;
            }
        }
        this.lastPoints = points;
        double[] ctrlPts = new double[points.length];
        System.arraycopy(points, 0, ctrlPts, 0, points.length);
        points = ctrlPts;
        if (points[0] == -1.0) {
            points[0] = 0.0;
        }
        if (points[points.length - 1] == -1.0) {
            points[points.length - 1] = 1.0;
        }
        int npoints = 0;
        for (double p : points) {
            if (!(p >= 0.0)) continue;
            ++npoints;
        }
        this.controlPoints = new double[npoints][2];
        npoints = 0;
        for (int i = 0; i < points.length; ++i) {
            if (!(points[i] >= 0.0)) continue;
            this.controlPoints[npoints][0] = (Math.pow(2.0, (double)i * 8.0 / (double)(points.length - 1)) - 1.0) / 255.0;
            this.controlPoints[npoints][1] = (Math.pow(2.0, points[i] * 8.0) - 1.0) / 255.0;
            ++npoints;
        }
        if (this.rendering.getEngine() != null) {
            this.rendering.getEngine().setFocusedZone(-1, this.controlPoints);
        }
        this.table = null;
        this.settingsChanged();
    }

    private static double fy(double y) {
        return Math.log1p(255.0 * y) / (8.0 * Math.log(2.0));
    }

    @Override
    public double getControlPoint(int index) {
        double y;
        double x = (Math.pow(2.0, (double)index * 8.0 / 16.0) - 1.0) / 255.0;
        if (this.controlPoints == null) {
            y = x;
        } else {
            double xmin = 0.0;
            double xmax = 1.0;
            double ymin = 0.0;
            double ymax = 1.0;
            for (double[] cp : this.controlPoints) {
                if (cp[0] == x) {
                    return ZoneOperationImpl.fy(cp[1]);
                }
                if (!(x > cp[0])) break;
                xmin = cp[0];
                ymin = cp[1];
            }
            for (int i = this.controlPoints.length - 1; i >= 0 && x <= this.controlPoints[i][0]; --i) {
                xmax = this.controlPoints[i][0];
                ymax = this.controlPoints[i][1];
            }
            y = (x - xmin) / (xmax - xmin) * (ymax - ymin) + ymin;
        }
        return ZoneOperationImpl.fy(y);
    }

    @Override
    public void setFocusPoint(int index) {
        int zoneIndex;
        int n = zoneIndex = index >= 0 ? (int)(16.0 * this.getControlPoint(index) + 0.5) : -1;
        if (this.rendering.getEngine() != null) {
            this.rendering.getEngine().setFocusedZone(zoneIndex, this.controlPoints);
        }
    }

    private void updateCurve() {
        double[] weights = new double[this.controlPoints.length];
        weights[this.controlPoints.length - 1] = 1.0;
        weights[0] = 1.0;
        for (int i = 1; i < this.controlPoints.length - 1; ++i) {
            weights[i] = 10.0;
        }
        splines.rbspline(3, this.controlPoints, weights, this.curve);
    }

    private LookupTableJAI computeTable(PlanarImage source) {
        if (this.table != null) {
            return this.table;
        }
        this.updateCurve();
        if (this.controlPoints.length > 2) {
            splines.interpolate(0.0, 1.0, 1.0 / (double)(this.tableData.length - 1), this.curve, this.tableData);
        } else {
            for (int i = 0; i < this.tableData.length; ++i) {
                double x = (double)i / (double)(this.tableData.length - 1);
                double y = this.controlPoints[0][1] + x * (this.controlPoints[1][1] - this.controlPoints[0][1]);
                this.tableData[i] = (short)((int)(y * (double)(this.tableData.length - 1) + 0.5) & 0xFFFF);
            }
        }
        this.table = source.getColorModel().getNumColorComponents() == 3 && this.scale == 1 ? new LightnessLookupTable(this.tableData, true) : new LookupTableJAI(this.tableData, true);
        return this.table;
    }

    private LookupTableJAI computeGammaTable(int dataType) {
        double gamma = 2.2;
        if (dataType == 0) {
            if (this.byteLut != null) {
                return this.byteLut;
            }
            for (int i = 0; i < this.tableDataByte.length; ++i) {
                this.tableDataByte[i] = (byte)(255.0 * Math.pow((double)i / 255.0, 2.2) + 0.5);
            }
            this.byteLut = new LookupTableJAI(this.tableDataByte);
            return this.byteLut;
        }
        if (this.ushortLut != null) {
            return this.ushortLut;
        }
        for (int i = 0; i < this.tableDataUShort.length; ++i) {
            this.tableDataUShort[i] = (short)(65535.0 * Math.pow((double)i / 65535.0, 2.2) + 0.5);
        }
        this.ushortLut = new LookupTableJAI(this.tableDataUShort, true);
        return this.ushortLut;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ZoneMapper(source);
    }

    private class ZoneMapper
    extends BlendedOperation.BlendedTransform {
        ZoneMapper(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            LookupTableJAI table = ZoneOperationImpl.this.computeTable(this.back);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(table);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout((RenderedImage)this.back));
            return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)hints);
        }
    }
}

