/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class WhiteBalance
extends BlendedOperation {
    static final String ORIGINAL = "Temperature";
    static final OperationType type = new OperationTypeImpl("White Point");
    private float original = 6500.0f;
    private float target = 6500.0f;
    private float[] Wt = null;

    public WhiteBalance(Rendering rendering) {
        super(rendering, type);
        this.colorInputOnly = true;
        this.addSliderKey(ORIGINAL);
        DecimalFormat format = new DecimalFormat("0");
        this.setSliderConfig(ORIGINAL, new SliderConfig(2000.0, 50000.0, this.original, 10.0, true, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (!key.equals(ORIGINAL) || (double)this.original == value) {
            return;
        }
        this.original = (float)value;
        this.Wt = null;
        super.setSliderValue(key, value);
    }

    static float[] W(float original, float target) {
        float[] originalW = ColorScience.W(original);
        float[] targetW = ColorScience.W(target);
        return new float[]{originalW[0] / targetW[0], originalW[1] / targetW[1], originalW[2] / targetW[2]};
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new WhiteBalanceTransform(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    static /* synthetic */ float[] access$002(WhiteBalance x0, float[] x1) {
        x0.Wt = x1;
        return x1;
    }

    private class WhiteBalanceTransform
    extends BlendedOperation.BlendedTransform {
        WhiteBalanceTransform(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            WhiteBalance.access$002(WhiteBalance.this, WhiteBalance.W(WhiteBalance.this.original, WhiteBalance.this.target));
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(WhiteBalance.this.Wt);
            return JAI.create((String)"MultiplyConst", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
    }
}

