/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.ImageProcessor;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;
import java.util.LinkedList;

public class UnSharpMaskOperation
extends BlendedOperation {
    private static final String AMOUNT = "Amount";
    private static final String RADIUS = "Radius";
    private static final String THRESHOLD = "Threshold";
    private static final String RGB = "RGB";
    static final OperationTypeImpl typeV1 = new OperationTypeImpl("UnSharp Mask");
    static final OperationTypeImpl typeV2 = new OperationTypeImpl("UnSharp Mask V2");
    static final OperationTypeImpl typeV3 = new OperationTypeImpl("UnSharp Mask V3");
    private double amount = 100.0;
    private double radius = 1.0;
    private double threshold = this.type != typeV1 ? 20.0 : 0.0;
    private boolean rgb = false;
    private static short[] tableData = new short[65536];
    private static short[] invTableData = new short[65536];
    private static LookupTableJAI table;
    private static LookupTableJAI invTable;
    private static GammaUSMProcessor GammaUSMProcessorInstance;
    private static LuminanceUSMProcessor LuminanceUSMProcessorInstance;

    public UnSharpMaskOperation(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.addSliderKey(AMOUNT);
        this.addSliderKey(RADIUS);
        if (type != typeV1) {
            this.addSliderKey(THRESHOLD);
        }
        this.setSliderConfig(AMOUNT, new SliderConfig(1.0, 500.0, this.amount, 1.0, true, new DecimalFormat("0")));
        this.setSliderConfig(RADIUS, new SliderConfig(0.1, 500.0, this.radius, 0.1, true, new DecimalFormat("0.0")));
        if (type != typeV1) {
            this.setSliderConfig(THRESHOLD, new SliderConfig(0.0, 100.0, this.threshold, 1.0, false, new DecimalFormat("0")));
        }
        if (type == typeV2) {
            LinkedList<String> cks = new LinkedList<String>();
            cks.add(RGB);
            this.setCheckboxKeys(cks);
        }
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals(AMOUNT) && this.amount != value) {
            this.amount = value;
        } else if (key.equals(RADIUS) && this.radius != value) {
            this.radius = value;
        } else if (key.equals(THRESHOLD) && this.threshold != value) {
            this.threshold = value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    public void setCheckboxValue(String key, boolean value) {
        if (key.equals(RGB)) {
            this.rgb = value;
        }
        super.setCheckboxValue(key, value);
    }

    private static double f(double x) {
        return (x *= 10.0) * (1.0 - 1.0 / Math.exp(x * x / 5.0)) / 10.0;
    }

    private static synchronized LookupTableJAI getTable() {
        if (table == null) {
            for (int i = 0; i < tableData.length; ++i) {
                UnSharpMaskOperation.tableData[i] = (short)(0xFFFF & (int)(65535.0 * UnSharpMaskOperation.f((double)i / 65535.0) + 0.5));
            }
            table = new LookupTableJAI(tableData, true);
        }
        return table;
    }

    private static int binSearch(int x) {
        int low = 0;
        int high = tableData.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (x < (0xFFFF & tableData[mid])) {
                high = mid - 1;
                continue;
            }
            if (x > (0xFFFF & tableData[mid])) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private static synchronized LookupTableJAI invertTable() {
        if (invTable == null) {
            UnSharpMaskOperation.getTable();
            for (int i = 0; i < invTableData.length; ++i) {
                int p = UnSharpMaskOperation.binSearch(i);
                UnSharpMaskOperation.invTableData[i] = (short)(p & 0xFFFF);
            }
            invTable = new LookupTableJAI(invTableData, true);
        }
        return invTable;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new UnSharpMask(source, this);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    static {
        GammaUSMProcessorInstance = new GammaUSMProcessor();
        LuminanceUSMProcessorInstance = new LuminanceUSMProcessor();
    }

    private class UnSharpMask
    extends BlendedOperation.BlendedTransform {
        Operation op;

        UnSharpMask(PlanarImage source, Operation op) {
            super(source);
            this.op = op;
        }

        public PlanarImage setFrontPlain() {
            RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.addSource(Functions.gaussianBlur((RenderedImage)this.back, UnSharpMaskOperation.this.rendering, this.op, UnSharpMaskOperation.this.radius * (double)UnSharpMaskOperation.this.scale));
            pb.add(UnSharpMaskOperation.this.amount / 100.0);
            pb.add((int)UnSharpMaskOperation.this.threshold);
            return JAI.create((String)"LCUnSharpMask", (ParameterBlock)pb, (RenderingHints)extenderHints);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.op = null;
        }

        public PlanarImage setFrontGamma() {
            double blurRadius = UnSharpMaskOperation.this.radius * (double)UnSharpMaskOperation.this.scale;
            RenderedOp blur = Functions.gaussianBlur((RenderedImage)this.back, UnSharpMaskOperation.this.rendering, this.op, GammaUSMProcessorInstance, blurRadius);
            RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(GammaUSMProcessorInstance.process((RenderedImage)this.back));
            pb.addSource(blur);
            pb.add(UnSharpMaskOperation.this.amount / 100.0);
            pb.add((int)UnSharpMaskOperation.this.threshold);
            RenderedOp usm = JAI.create((String)"LCUnSharpMask", (ParameterBlock)pb, (RenderingHints)extenderHints);
            usm.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
            pb = new ParameterBlock();
            pb.addSource(usm);
            pb.add(UnSharpMaskOperation.getTable());
            return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }

        public PlanarImage setFrontLuminance() {
            ColorScience.YST yst = new ColorScience.YST();
            double[][] rgb2yst = yst.fromRGB(this.back.getSampleModel().getDataType());
            double[][] yst2rgb = yst.toRGB(this.back.getSampleModel().getDataType());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(rgb2yst);
            RenderedOp ystImage = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
            pb = new ParameterBlock();
            pb.addSource(ystImage);
            pb.add(new int[]{1, 2});
            RenderedOp cc = JAI.create((String)"bandselect", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            pb = new ParameterBlock();
            pb.addSource(LuminanceUSMProcessorInstance.process((RenderedImage)this.back));
            pb.addSource(Functions.gaussianBlur((RenderedImage)this.back, UnSharpMaskOperation.this.rendering, this.op, LuminanceUSMProcessorInstance, UnSharpMaskOperation.this.radius * (double)UnSharpMaskOperation.this.scale));
            pb.add(UnSharpMaskOperation.this.amount / 100.0);
            pb.add((int)UnSharpMaskOperation.this.threshold);
            RenderedOp usm = JAI.create((String)"LCUnSharpMask", (ParameterBlock)pb, (RenderingHints)extenderHints);
            usm.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
            pb = new ParameterBlock();
            pb.addSource(usm);
            pb.add(UnSharpMaskOperation.getTable());
            RenderedOp invLookup = JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            RenderingHints layoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, Functions.getImageLayout((RenderedImage)ystImage));
            pb = new ParameterBlock();
            pb.addSource(invLookup);
            pb.addSource(cc);
            layoutHints.add(JAIContext.noCacheHint);
            RenderedOp denoisedyst = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)layoutHints);
            pb = new ParameterBlock();
            pb.addSource(denoisedyst);
            pb.add(yst2rgb);
            return JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }

        @Override
        public PlanarImage setFront() {
            if (UnSharpMaskOperation.this.type != typeV1 && !UnSharpMaskOperation.this.rgb) {
                return this.setFrontLuminance();
            }
            return this.setFrontGamma();
        }
    }

    static class LuminanceUSMProcessor
    implements ImageProcessor {
        LuminanceUSMProcessor() {
        }

        @Override
        public RenderedOp process(RenderedImage source) {
            double[][] yChannel = new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}};
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(source);
            pb.add(yChannel);
            RenderedOp y = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
            pb = new ParameterBlock();
            pb.addSource(y);
            pb.add(UnSharpMaskOperation.invertTable());
            return JAI.create((String)"lookup", (ParameterBlock)pb, null);
        }
    }

    static class GammaUSMProcessor
    implements ImageProcessor {
        GammaUSMProcessor() {
        }

        @Override
        public RenderedOp process(RenderedImage source) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(source);
            pb.add(UnSharpMaskOperation.invertTable());
            return JAI.create((String)"lookup", (ParameterBlock)pb, null);
        }
    }
}

