/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.LayerModeImpl;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.LayerConfig;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class ContrastMaskOperation
extends BlendedOperation {
    private double radius = 128.0;
    private double gamma = 2.2;
    private KernelJAI kernel = null;
    private short[] tableDataUShort = new short[65536];
    private byte[] tableDataByte = new byte[256];
    private LookupTableJAI byteLut = null;
    private LookupTableJAI ushortLut = null;
    static final OperationType type = new OperationTypeImpl("Contrast Mask");

    public ContrastMaskOperation(Rendering rendering) {
        super(rendering, type);
        DecimalFormat format = new DecimalFormat("0.0");
        this.addSliderKey("Radius");
        this.setSliderConfig("Radius", new SliderConfig(0.1, 500.0, this.radius, 0.1, true, format));
        this.addSliderKey("Gamma");
        this.setSliderConfig("Gamma", new SliderConfig(0.2, 5.0, this.gamma, 0.1, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals("Radius") && this.radius != value) {
            this.radius = value;
            this.kernel = null;
        } else if (key.equals("Gamma") && this.gamma != value) {
            this.gamma = value;
            this.byteLut = null;
            this.ushortLut = null;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    private LookupTableJAI computeGammaTable(int dataType) {
        if (dataType == 0) {
            if (this.byteLut != null) {
                return this.byteLut;
            }
            for (int i = 0; i < this.tableDataByte.length; ++i) {
                this.tableDataByte[i] = (byte)(255.0 * Math.pow((double)i / 255.0, this.gamma) + 0.5);
            }
            this.byteLut = new LookupTableJAI(this.tableDataByte);
            return this.byteLut;
        }
        if (this.ushortLut != null) {
            return this.ushortLut;
        }
        for (int i = 0; i < this.tableDataUShort.length; ++i) {
            this.tableDataUShort[i] = (short)(65535.0 * Math.pow((double)i / 65535.0, this.gamma) + 0.5);
        }
        this.ushortLut = new LookupTableJAI(this.tableDataUShort, true);
        return this.ushortLut;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ContrastMask(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    @Override
    public LayerConfig getDefaultLayerConfig() {
        return new LayerConfig(new LayerModeImpl("Soft Light"), 0.5);
    }

    private class ContrastMask
    extends BlendedOperation.BlendedTransform {
        RenderedOp gammaCurve;

        ContrastMask(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            PlanarImage scaleDown;
            double[][] transform = new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}};
            double newRadius = ContrastMaskOperation.this.radius * (double)ContrastMaskOperation.this.scale;
            double rescale = 1.0;
            int divideByTwo = 1;
            while (newRadius > 7.0) {
                newRadius /= 2.0;
                rescale /= 2.0;
                divideByTwo *= 2;
            }
            RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            Interpolation interp = Interpolation.getInstance((int)1);
            if (rescale != 1.0) {
                float scaleX = (float)Math.floor(rescale * (double)this.back.getWidth()) / (float)this.back.getWidth();
                float scaleY = (float)Math.floor(rescale * (double)this.back.getHeight()) / (float)this.back.getHeight();
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(this.back);
                pb.add(AffineTransform.getScaleInstance(scaleX, scaleY));
                pb.add(interp);
                RenderingHints layoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, Math.max(512 / divideByTwo, 8), Math.max(512 / divideByTwo, 8), null, null));
                layoutHints.add(hints);
                layoutHints.add(JAIContext.noCacheHint);
                scaleDown = JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)layoutHints);
            } else {
                scaleDown = this.back;
            }
            if (scaleDown.getColorModel().getNumComponents() == 3) {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(scaleDown);
                pb.add(transform);
                scaleDown = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            }
            scaleDown = JAI.create((String)"Not", (RenderedImage)scaleDown, (Object)JAIContext.noCacheHint);
            LookupTableJAI table = ContrastMaskOperation.this.computeGammaTable(scaleDown.getSampleModel().getDataType());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(scaleDown);
            pb.add(table);
            this.gammaCurve = JAI.create((String)"lookup", (ParameterBlock)pb, null);
            ContrastMaskOperation.this.kernel = Functions.getGaussKernel(newRadius);
            pb = new ParameterBlock();
            pb.addSource(this.gammaCurve);
            pb.add(ContrastMaskOperation.this.kernel);
            RenderedOp blur = JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, (RenderingHints)hints);
            if (rescale != 1.0) {
                pb = new ParameterBlock();
                pb.addSource(blur);
                pb.add(AffineTransform.getScaleInstance((double)this.back.getWidth() / (double)scaleDown.getWidth(), (double)this.back.getHeight() / (double)scaleDown.getHeight()));
                pb.add(interp);
                RenderingHints resultLayoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, 512, 512, null, null));
                resultLayoutHints.add(hints);
                resultLayoutHints.add(JAIContext.noCacheHint);
                return JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)resultLayoutHints);
            }
            return blur;
        }
    }
}

