/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.ImageEditor.Locale;
import com.lightcrafts.model.ImageEditor.PaintListener;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.ref.SoftReference;

public class ColorSelectionPreview
extends Preview
implements PaintListener {
    static final boolean ADJUST_GRAYSCALE = true;
    final ImageEditorEngine engine;
    private SoftReference<PlanarImage> currentImage = new SoftReference<Object>(null);
    private Rectangle visibleRect = null;
    private BufferedImage preview = null;

    @Override
    public String getName() {
        return Locale.LOCALE.get("ColorMask_Name");
    }

    @Override
    public void setDropper(Point p) {
    }

    @Override
    public void addNotify() {
        this.engine.update(null, false);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    @Override
    public void setRegion(Region region) {
    }

    @Override
    public void setSelected(Boolean selected) {
        if (!selected.booleanValue()) {
            this.preview = null;
            this.currentImage = new SoftReference<Object>(null);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Shape clip = g.getClip();
        g.setColor(LightZoneSkin.Colors.NeutralGray);
        g.fill(clip);
        if (this.preview == null) {
            PlanarImage image = this.currentImage.get();
            if (image == null) {
                this.engine.update(null, false);
            } else if (this.visibleRect != null && this.getHeight() > 1 && this.getWidth() > 1) {
                this.preview = this.cropScaleGrayscale(this.visibleRect, (RenderedImage)image);
            }
        }
        if (this.preview == null) {
            return;
        }
        AffineTransform transform = new AffineTransform();
        int dx = this.getSize().width > this.preview.getWidth() ? (this.getSize().width - this.preview.getWidth()) / 2 : 0;
        int dy = this.getSize().height > this.preview.getHeight() ? (this.getSize().height - this.preview.getHeight()) / 2 : 0;
        transform.setToTranslation(dx, dy);
        try {
            g.drawRenderedImage(this.preview, transform);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    ColorSelectionPreview(final ImageEditorEngine engine) {
        this.engine = engine;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                if (ColorSelectionPreview.this.isShowing()) {
                    engine.update(null, false);
                }
            }
        });
    }

    private BufferedImage cropScaleGrayscale(Rectangle visibleRect, RenderedImage image) {
        Rectangle bounds = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        if (bounds.contains(visibleRect = bounds.intersection(visibleRect))) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add((float)visibleRect.x);
            pb.add((float)visibleRect.y);
            pb.add((float)visibleRect.width);
            pb.add((float)visibleRect.height);
            image = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
        Dimension previewSize = this.getSize();
        if (visibleRect.width > previewSize.width || visibleRect.height > previewSize.height) {
            float scale = Math.min((float)previewSize.width / (float)visibleRect.width, (float)previewSize.height / (float)visibleRect.height);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(scale);
            pb.add(scale);
            image = JAI.create((String)"Scale", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
        if ((image = Functions.toColorSpace(image, JAIContext.systemColorSpace, null)).getSampleModel().getDataType() == 1) {
            image = Functions.fromUShortToByte(image, null);
        }
        return Functions.toFastBufferedImage(image);
    }

    @Override
    public void paintDone(PlanarImage image, Rectangle visibleRect, boolean synchronous, long time) {
        PlanarImage selectionMask;
        if (image == null) {
            return;
        }
        Dimension previewDimension = this.getSize();
        if (previewDimension.getHeight() <= 1.0 || previewDimension.getWidth() <= 1.0) {
            return;
        }
        Operation op = this.engine.getSelectedOperation();
        if (op != null && op instanceof BlendedOperation && op.isActive() && !op.getColorSelection().isAllSelected() && (selectionMask = ((BlendedOperation)op).getColorSelectionMask()) != null) {
            image = selectionMask;
        }
        this.visibleRect = visibleRect;
        this.currentImage = new SoftReference<PlanarImage>(image);
        this.preview = null;
        this.repaint();
    }
}

