/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ColorPickerDropperOperation;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorMatrix2;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.splines;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Map;

public class ColorBalanceOperationV2
extends BlendedOperation
implements ColorPickerDropperOperation {
    static final OperationType typeV2 = new OperationTypeImpl("Color Balance V2");
    static final OperationType typeV3 = new OperationTypeImpl("Color Balance V3");
    private final String MIDPOINT = "Midpoint";
    private double midpoint = 0.18;
    private Color color = Color.gray;
    private Point2D p = null;

    public ColorBalanceOperationV2(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.colorInputOnly = true;
        DecimalFormat format = new DecimalFormat("0.00");
        this.addSliderKey("Midpoint");
        this.setSliderConfig("Midpoint", new SliderConfig(0.01, 1.0, this.midpoint, 0.01, true, format));
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (!key.equals("Midpoint") || this.midpoint == value) {
            return;
        }
        this.midpoint = value;
        super.setSliderValue(key, value);
    }

    @Override
    public Map<String, Double> setColor(Point2D p) {
        this.p = p;
        this.settingsChanged();
        return Collections.singletonMap("Midpoint", this.midpoint);
    }

    @Override
    public Map<String, Double> setColor(Color color) {
        this.color = color;
        this.p = null;
        this.settingsChanged();
        return Collections.emptyMap();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    private static int clipColor(int color) {
        return color < 0 ? 0 : (color > 255 ? 255 : color);
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ColorBalanceV2(source);
    }

    @Override
    public boolean neutralDefault() {
        return true;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class ColorBalanceV2
    extends BlendedOperation.BlendedTransform {
        ColorBalanceV2(PlanarImage source) {
            super(source);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public PlanarImage setFront() {
            int i;
            int[] pixel;
            if (ColorBalanceOperationV2.this.p == null && ColorBalanceOperationV2.this.color == null) {
                return this.back;
            }
            if (ColorBalanceOperationV2.this.p != null) {
                pixel = this.pointToPixel(ColorBalanceOperationV2.this.p);
                if (pixel == null) {
                    System.out.println("Something funny here...");
                    return this.back;
                }
                if (ColorBalanceOperationV2.this.type == typeV2) {
                    int r = pixel[0] / 256;
                    int g = pixel[1] / 256;
                    int b = pixel[2] / 256;
                    float[][] matrix = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
                    ColorMatrix2.huerotatemat(matrix, 180.0f);
                    int red = ColorBalanceOperationV2.clipColor((int)((float)r * matrix[0][0] + (float)g * matrix[1][0] + (float)b * matrix[2][0]));
                    int green = ColorBalanceOperationV2.clipColor((int)((float)r * matrix[0][1] + (float)g * matrix[1][1] + (float)b * matrix[2][1]));
                    int blue = ColorBalanceOperationV2.clipColor((int)((float)r * matrix[0][2] + (float)g * matrix[1][2] + (float)b * matrix[2][2]));
                    ColorBalanceOperationV2.this.color = new Color(red, green, blue);
                } else {
                    float[] hsb = new float[3];
                    hsb = Color.RGBtoHSB(pixel[0] / 256, pixel[1] / 256, pixel[2] / 256, hsb);
                    hsb[0] = (float)((double)hsb[0] + 0.5);
                    if (hsb[0] >= 1.0f) {
                        hsb[0] = hsb[0] - 1.0f;
                    }
                    ColorBalanceOperationV2.this.color = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
                }
                ColorBalanceOperationV2.this.midpoint = (double)(ColorScience.Wr * (float)pixel[0] + ColorScience.Wg * (float)pixel[1] + ColorScience.Wb * (float)pixel[2]) / 65535.0;
                ColorBalanceOperationV2.this.p = null;
            } else {
                pixel = new int[]{ColorBalanceOperationV2.this.color.getRed() * 256, ColorBalanceOperationV2.this.color.getGreen() * 256, ColorBalanceOperationV2.this.color.getBlue() * 256};
            }
            double tred = pixel[0] / 2 - pixel[2] / 4 - pixel[1] / 4;
            double tgreen = pixel[1] / 2 - pixel[0] / 4 - pixel[2] / 4;
            double tblue = pixel[2] / 2 - pixel[0] / 4 - pixel[1] / 4;
            double[][] polygon = new double[][]{{0.0, 0.0}, {ColorBalanceOperationV2.this.midpoint, 0.0}, {1.0, 0.0}};
            polygon[1][1] = tred / 256.0;
            double[][] redCurve = new double[256][2];
            splines.bspline(2, polygon, redCurve);
            polygon[1][1] = tgreen / 256.0;
            double[][] greenCurve = new double[256][2];
            splines.bspline(2, polygon, greenCurve);
            polygon[1][1] = tblue / 256.0;
            double[][] blueCurve = new double[256][2];
            splines.bspline(2, polygon, blueCurve);
            short[][] table = new short[3][65536];
            splines.Interpolator interpolator = new splines.Interpolator();
            for (i = 0; i < 65536; ++i) {
                table[0][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, redCurve), 0.0), 65535.0));
            }
            interpolator.reset();
            for (i = 0; i < 65536; ++i) {
                table[1][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, greenCurve), 0.0), 65535.0));
            }
            interpolator.reset();
            i = 0;
            while (true) {
                if (i >= 65536) {
                    LookupTableJAI lookupTable = new LookupTableJAI(table, true);
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(this.back);
                    pb.add(lookupTable);
                    return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
                }
                table[2][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, blueCurve), 0.0), 65535.0));
                ++i;
            }
        }
    }
}

