/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.jai.utils.Job;
import com.lightcrafts.jai.utils.LCTileScheduler;
import java.util.LinkedList;

class WorkerThread
extends Thread {
    public static final Object TERMINATE = new Object();
    final LCTileScheduler scheduler;
    boolean isPrefetch;

    public WorkerThread(ThreadGroup group, LCTileScheduler scheduler, boolean isPrefetch) {
        super(group, group.getName() + group.activeCount());
        this.scheduler = scheduler;
        this.isPrefetch = isPrefetch;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList<Object> jobQueue = this.scheduler.getQueue(this.isPrefetch);
        while (true) {
            Object object;
            Object dequeuedObject = null;
            if (jobQueue.size() > 0) {
                dequeuedObject = jobQueue.removeFirst();
            } else {
                try {
                    jobQueue.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (dequeuedObject == TERMINATE || this.getThreadGroup() == null || this.getThreadGroup().isDestroyed()) {
                LinkedList<Thread> threads = this.scheduler.getWorkers(this.isPrefetch);
                object = threads;
                synchronized (threads) {
                    threads.remove(this);
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return;
                }
            }
            Job job = (Job)dequeuedObject;
            if (job == null) continue;
            job.compute();
            if (!job.isBlocking()) continue;
            object = this.scheduler;
            synchronized (object) {
                this.scheduler.notify();
            }
        }
    }
}

