/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class RedMaskBlackener
extends PointOpImage {
    private static short[] powTable = new short[65536];

    public RedMaskBlackener(RenderedImage source, RenderedImage mask, Map config) {
        super(source, mask, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor mask = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[2], this.getColorModel());
        switch (dst.getDataType()) {
            case 1: {
                this.ushortLoop(src, mask, dst);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dst.getDataType());
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor mask, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] dstData = dst.getShortDataArray(0);
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getShortDataArray(0);
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        byte[] maskData = mask.getByteDataArray(0);
        int[] maskBandOffsets = mask.getBandOffsets();
        int maskLineStride = mask.getScanlineStride();
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        int maskOffset = maskBandOffsets[0];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                short r = srcData[srcPixelStride * col + row * srcLineStride + srcROffset];
                short g = srcData[srcPixelStride * col + row * srcLineStride + srcGOffset];
                short b = srcData[srcPixelStride * col + row * srcLineStride + srcBOffset];
                int m = 0xFF & maskData[col + row * maskLineStride + maskOffset];
                if (m == 0) {
                    dstData[dstPixelStride * col + row * dstLineStride + dstROffset] = r;
                    dstData[dstPixelStride * col + row * dstLineStride + dstGOffset] = g;
                    dstData[dstPixelStride * col + row * dstLineStride + dstBOffset] = b;
                    continue;
                }
                short gg = powTable[0xFFFF & g];
                int r1 = ((255 - m) * (0xFFFF & r) + m * gg) / 255;
                int g1 = ((255 - m) * (0xFFFF & g) + m * gg) / 255;
                int b1 = ((255 - m) * (0xFFFF & b) + m * gg) / 255;
                dstData[dstPixelStride * col + row * dstLineStride + dstROffset] = (short)r1;
                dstData[dstPixelStride * col + row * dstLineStride + dstGOffset] = (short)g1;
                dstData[dstPixelStride * col + row * dstLineStride + dstBOffset] = (short)b1;
            }
        }
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            RedMaskBlackener.powTable[i] = (short)(65535.0 * Math.pow((double)i / 65535.0, 1.4));
        }
    }
}

