/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import Jama.Matrix;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.utils.HSB;
import java.awt.Rectangle;
import java.awt.color.ICC_ProfileRGB;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class HueRotateOpImage
extends PointOpImage {
    private float angle;
    private float[][] toSRGB;
    private float[][] toLinearRGB;

    public HueRotateOpImage(RenderedImage source, float angle, Map config) {
        super(source, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
        this.angle = angle;
        ICC_ProfileRGB sRGB = (ICC_ProfileRGB)JAIContext.sRGBColorProfile;
        this.toSRGB = new Matrix(sRGB.getMatrix()).inverse().times(new Matrix(((ICC_ProfileRGB)JAIContext.linearProfile).getMatrix())).getArrayFloat();
        this.toLinearRGB = new Matrix(sRGB.getMatrix()).inverse().times(new Matrix(((ICC_ProfileRGB)JAIContext.linearProfile).getMatrix())).inverse().getArrayFloat();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dst.getDataType()) {
            case 1: {
                this.ushortLoop(src, dst);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dst.getDataType());
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] dstData = dst.getShortDataArray(0);
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getShortDataArray(0);
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        float[] rgb = new float[3];
        float[] hsi = new float[3];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int srcPixOffset = srcPixelStride * col + row * srcLineStride;
                int r = 0xFFFF & srcData[srcPixOffset + srcROffset];
                int g = 0xFFFF & srcData[srcPixOffset + srcGOffset];
                int b = 0xFFFF & srcData[srcPixOffset + srcBOffset];
                rgb[0] = (this.toSRGB[0][0] * (float)r + this.toSRGB[0][1] * (float)g + this.toSRGB[0][2] * (float)b) / 65535.0f;
                rgb[1] = (this.toSRGB[1][0] * (float)r + this.toSRGB[1][1] * (float)g + this.toSRGB[1][2] * (float)b) / 65535.0f;
                rgb[2] = (this.toSRGB[2][0] * (float)r + this.toSRGB[2][1] * (float)g + this.toSRGB[2][2] * (float)b) / 65535.0f;
                HSB.fromRGB(rgb, hsi);
                hsi[0] = hsi[0] + this.angle;
                if (hsi[0] < 0.0f) {
                    hsi[0] = hsi[0] + 1.0f;
                } else if (hsi[0] >= 1.0f) {
                    hsi[0] = hsi[0] - 1.0f;
                }
                HSB.toRGB(hsi, rgb);
                r = (int)(65535.0f * (this.toLinearRGB[0][0] * rgb[0] + this.toLinearRGB[0][1] * rgb[1] + this.toLinearRGB[0][2] * rgb[2]));
                g = (int)(65535.0f * (this.toLinearRGB[1][0] * rgb[0] + this.toLinearRGB[1][1] * rgb[1] + this.toLinearRGB[1][2] * rgb[2]));
                b = (int)(65535.0f * (this.toLinearRGB[2][0] * rgb[0] + this.toLinearRGB[2][1] * rgb[1] + this.toLinearRGB[2][2] * rgb[2]));
                int dstPixOffset = dstPixelStride * col + row * dstLineStride;
                dstData[dstPixOffset + dstROffset] = (short)(r < 0 ? 0 : (r > 65535 ? 65535 : r));
                dstData[dstPixOffset + dstGOffset] = (short)(g < 0 ? 0 : (g > 65535 ? 65535 : g));
                dstData[dstPixOffset + dstBOffset] = (short)(b < 0 ? 0 : (b > 65535 ? 65535 : b));
            }
        }
    }
}

