/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;

public final class FastBilateralFilterOpImage
extends AreaOpImage {
    private final float sigma_d;
    private final float sigma_r;
    private static final BorderExtender copyExtender = BorderExtender.createInstance((int)1);
    private static final float[] transform = new float[65536];

    private static ImageLayout fblLayout(RenderedImage source) {
        class TwoComponentsColorSpace
        extends ColorSpace {
            TwoComponentsColorSpace() {
                super(12, 2);
            }

            @Override
            public float[] toRGB(float[] colorvalue) {
                if (colorvalue.length < 2) {
                    throw new ArrayIndexOutOfBoundsException("colorvalue.length < 2");
                }
                return colorvalue;
            }

            @Override
            public float[] fromRGB(float[] rgbvalue) {
                if (rgbvalue.length < 2) {
                    throw new ArrayIndexOutOfBoundsException("rgbvalue.length < 3");
                }
                return new float[]{rgbvalue[0], rgbvalue[1]};
            }

            @Override
            public float[] toCIEXYZ(float[] colorvalue) {
                if (colorvalue.length < 2) {
                    throw new ArrayIndexOutOfBoundsException("colorvalue.length < 2");
                }
                return colorvalue;
            }

            @Override
            public float[] fromCIEXYZ(float[] xyzvalue) {
                if (xyzvalue.length < 2) {
                    throw new ArrayIndexOutOfBoundsException("xyzvalue.length < 3");
                }
                return new float[]{xyzvalue[0], xyzvalue[1]};
            }
        }
        ComponentColorModel cm = new ComponentColorModel(new TwoComponentsColorSpace(), false, false, 1, 1);
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(source.getWidth(), source.getHeight());
        return new ImageLayout(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight(), source.getTileGridXOffset(), source.getTileGridYOffset(), source.getTileWidth(), source.getTileHeight(), sm, (ColorModel)cm);
    }

    public FastBilateralFilterOpImage(RenderedImage source, Map config, float sigma_d, float sigma_r) {
        super(source, FastBilateralFilterOpImage.fblLayout(source), config, true, copyExtender, (int)(2.0 * Math.ceil(sigma_d)), (int)(2.0 * Math.ceil(sigma_d)), (int)(2.0 * Math.ceil(sigma_d)), (int)(2.0 * Math.ceil(sigma_d)));
        this.sigma_d = sigma_d;
        this.sigma_r = sigma_r;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int swidth = src.getWidth();
        int sheight = src.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcScanlineStride = src.getScanlineStride();
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        if (src.getNumBands() == 1) {
            FastBilateralFilterOpImage.fastBilateralFilterMono(srcData, dstData, this.sigma_d, this.sigma_r, swidth, sheight, src.getPixelStride(), dst.getPixelStride(), srcBandOffsets[0], dstBandOffsets[0], srcScanlineStride, dstScanlineStride, transform);
        } else {
            FastBilateralFilterOpImage.fastBilateralFilterChroma(srcData, dstData, this.sigma_d, this.sigma_r, swidth, sheight, src.getPixelStride(), dst.getPixelStride(), srcBandOffsets[0], srcBandOffsets[1], srcBandOffsets[2], dstBandOffsets[0], dstBandOffsets[1], dstBandOffsets[2], srcScanlineStride, dstScanlineStride);
        }
    }

    static native void fastBilateralFilterMono(short[] var0, short[] var1, float var2, float var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, float[] var12);

    static native void fastBilateralFilterChroma(short[] var0, short[] var1, float var2, float var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15);

    static native void fastBilateralFilterColor(short[] var0, short[] var1, float var2, float var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15);

    static {
        for (int i = 0; i < 65536; ++i) {
            float x = (float)i / 65536.0f;
            FastBilateralFilterOpImage.transform[i] = (float)(Math.log1p(x) / Math.log(2.0) + 1.5 * Math.exp(-10.0f * x) * Math.pow(x, 0.7));
        }
    }
}

