/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.image.color.ColorScience;
import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public final class BilateralFilterRGBOpImage
extends AreaOpImage {
    private final int y_wr;
    private final int c_wr;
    private final int y_ws;
    private final int c_ws;
    private final float[] y_kernel;
    private final float[] c_kernel;
    private final float y_scale_r;
    private final float c_scale_r;
    private final float[] rgb_to_yst;
    private final float[] yst_to_rgb;

    private static float SQR(float s) {
        return s * s;
    }

    private static int border(float y_sigma_d, float c_sigma_d) {
        return (int)Math.max(Math.ceil(y_sigma_d), Math.ceil(c_sigma_d));
    }

    public BilateralFilterRGBOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, float y_sigma_d, float y_sigma_r, float c_sigma_d, float c_sigma_r) {
        super(source, layout, config, true, extender, BilateralFilterRGBOpImage.border(y_sigma_d, c_sigma_d), BilateralFilterRGBOpImage.border(y_sigma_d, c_sigma_d), BilateralFilterRGBOpImage.border(y_sigma_d, c_sigma_d), BilateralFilterRGBOpImage.border(y_sigma_d, c_sigma_d));
        int i;
        this.y_wr = (int)Math.ceil(y_sigma_d);
        this.y_ws = 2 * this.y_wr + 1;
        this.y_kernel = new float[this.y_ws];
        for (i = -this.y_wr; i <= this.y_wr; ++i) {
            this.y_kernel[this.y_wr + i] = (float)((double)(1.0f / (2.0f * BilateralFilterRGBOpImage.SQR(y_sigma_d)) * (float)i * (float)i) + 0.25);
        }
        this.y_scale_r = 1.0f / (2.0f * BilateralFilterRGBOpImage.SQR(y_sigma_r));
        this.c_wr = (int)Math.ceil(c_sigma_d);
        this.c_ws = 2 * this.c_wr + 1;
        this.c_kernel = new float[this.c_ws];
        for (i = -this.c_wr; i <= this.c_wr; ++i) {
            this.c_kernel[this.c_wr + i] = (float)((double)(1.0f / (2.0f * BilateralFilterRGBOpImage.SQR(c_sigma_d)) * (float)i * (float)i) + 0.25);
        }
        this.c_scale_r = 1.0f / (2.0f * BilateralFilterRGBOpImage.SQR(c_sigma_r));
        ColorScience.YST transform = new ColorScience.YST();
        double[][] rgb2yst = transform.fromRGB(4);
        this.rgb_to_yst = new float[9];
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.rgb_to_yst[3 * i2 + j] = (float)rgb2yst[i2][j];
            }
        }
        double[][] yst2rgb = transform.toRGB(4);
        this.yst_to_rgb = new float[9];
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j = 0; j < 3; ++j) {
                this.yst_to_rgb[3 * i3 + j] = (float)yst2rgb[i3][j];
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int swidth = src.getWidth();
        int sheight = src.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcScanlineStride = src.getScanlineStride();
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        if (src.getNumBands() == 3) {
            BilateralFilterRGBOpImage.bilateralFilterRGB(srcData, dstData, this.y_wr, this.c_wr, this.y_ws, this.c_ws, 4.0f * this.y_scale_r, 4.0f * this.c_scale_r, this.y_kernel, this.c_kernel, this.rgb_to_yst, this.yst_to_rgb, swidth, sheight, srcBandOffsets[0], srcBandOffsets[1], srcBandOffsets[2], dstBandOffsets[0], dstBandOffsets[1], dstBandOffsets[2], srcScanlineStride, dstScanlineStride);
        }
    }

    static native void bilateralFilterRGB(short[] var0, short[] var1, int var2, int var3, int var4, int var5, float var6, float var7, float[] var8, float[] var9, float[] var10, float[] var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19, int var20, int var21);
}

