/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.operator;

import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationDescriptorImpl;
import com.lightcrafts.mediax.jai.ParameterBlockJAI;
import com.lightcrafts.mediax.jai.RenderableOp;
import com.lightcrafts.mediax.jai.RenderedOp;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;

public class LCBandCombineDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "LCBandCombine"}, {"LocalName", "LCBandCombine"}, {"Vendor", "com.lightcrafts.jai"}, {"Description", "Faster BandCombine Operation"}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BandCombineDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "An Image"}};
    private static final Class[] paramClasses = new Class[]{double[][].class};
    private static final String[] paramNames = new String[]{"matrix"};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public LCBandCombineDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateArguments(modeName, args, message)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage src = args.getRenderedSource(0);
        double[][] matrix = (double[][])args.getObjectParameter(0);
        SampleModel sm = src.getSampleModel();
        int rowLength = sm.getNumBands() + 1;
        if (matrix.length < 1) {
            message.append(this.getName()).append(": ").append("bad matrix dimensions");
            return false;
        }
        for (double[] aMatrix : matrix) {
            if (aMatrix.length == rowLength) continue;
            message.append(this.getName()).append(": ").append("bad matrix dimensions");
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, double[][] matrix, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("LCBandCombine", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("matrix", (Object)matrix);
        return JAI.create((String)"LCBandCombine", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, double[][] matrix, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("LCBandCombine", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("matrix", (Object)matrix);
        return JAI.createRenderable((String)"LCBandCombine", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

