/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai;

import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.utils.ColorScience;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class LightnessLookupTable
extends LookupTableJAI {
    public LightnessLookupTable(short[] shorts, boolean b) {
        super(shorts, b);
    }

    public WritableRaster lookup(Raster src, WritableRaster dst, Rectangle rect) {
        SampleModel dstSampleModel;
        if (src == null) {
            throw new IllegalArgumentException("Null Source");
        }
        if (src.getNumBands() != 3) {
            return super.lookup(src, dst, rect);
        }
        SampleModel srcSampleModel = src.getSampleModel();
        if (!this.isIntegralDataType(srcSampleModel)) {
            throw new IllegalArgumentException("Source Data Type must be an Integral Data Type");
        }
        rect = rect == null ? src.getBounds() : rect.intersection(src.getBounds());
        if (dst != null) {
            rect = rect.intersection(dst.getBounds());
        }
        if (dst == null) {
            dstSampleModel = this.getDestSampleModel(srcSampleModel, rect.width, rect.height);
            dst = RasterFactory.createWritableRaster((SampleModel)dstSampleModel, (Point)new Point(rect.x, rect.y));
        } else {
            dstSampleModel = dst.getSampleModel();
            if (dstSampleModel.getTransferType() != this.getDataType() || dstSampleModel.getNumBands() != this.getDestNumBands(srcSampleModel.getNumBands())) {
                throw new IllegalArgumentException("Incompatible Destination Image");
            }
        }
        int sTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)srcSampleModel);
        int dTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)dstSampleModel);
        RasterFormatTag sTag = new RasterFormatTag(srcSampleModel, sTagID);
        RasterFormatTag dTag = new RasterFormatTag(dstSampleModel, dTagID);
        RasterAccessor s = new RasterAccessor(src, rect, sTag, null);
        RasterAccessor d = new RasterAccessor((Raster)dst, rect, dTag, null);
        int width = d.getWidth();
        int height = d.getHeight();
        int bands = d.getNumBands();
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int[] srcBandOffsets = s.getBandOffsets();
        short[][] srcData = s.getShortDataArrays();
        int[] tblOffsets = this.getOffsets();
        short[][] tblData = this.getShortData();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        short[][] dstData = d.getShortDataArrays();
        int lowBandOffset = 0;
        for (int b = 0; b < bands; ++b) {
            if (srcBandOffsets[b] >= srcBandOffsets[lowBandOffset]) continue;
            lowBandOffset = b;
        }
        short[] sd = srcData[lowBandOffset];
        short[] dd = dstData[lowBandOffset];
        short[] td = tblData[0];
        int srcLineOffset = srcBandOffsets[lowBandOffset];
        int dstLineOffset = dstBandOffsets[lowBandOffset];
        int tblOffset = tblOffsets[0];
        for (int h = 0; h < height; ++h) {
            int srcPixelOffset = srcLineOffset;
            int dstPixelOffset = dstLineOffset;
            srcLineOffset += srcLineStride;
            dstLineOffset += dstLineStride;
            int scale = 16384;
            int minOffset = Math.min(srcBandOffsets[0], Math.min(srcBandOffsets[1], srcBandOffsets[2]));
            int wr = (int)(ColorScience.W[srcBandOffsets[0] - minOffset] * 16384.0f);
            int wg = (int)(ColorScience.W[srcBandOffsets[1] - minOffset] * 16384.0f);
            int wb = (int)(ColorScience.W[srcBandOffsets[2] - minOffset] * 16384.0f);
            for (int w = 0; w < width; ++w) {
                int sr = sd[srcPixelOffset + 0] & 0xFFFF;
                int sg = sd[srcPixelOffset + 1] & 0xFFFF;
                int sb = sd[srcPixelOffset + 2] & 0xFFFF;
                int lum = (wr * sr + wg * sg + wb * sb) / 16384;
                int index = lum - tblOffset;
                int val = td[index < 0 ? 0 : (index >= 65535 ? 65535 : index)] & 0xFFFF;
                int mul = lum > 0 ? 16384 * val / lum : 16384;
                int prod = mul * sr / 16384;
                dd[dstPixelOffset + 0] = (short)(prod > 65535 ? -1 : (short)prod);
                prod = mul * sg / 16384;
                dd[dstPixelOffset + 1] = (short)(prod > 65535 ? -1 : (short)prod);
                prod = mul * sb / 16384;
                dd[dstPixelOffset + 2] = (short)(prod > 65535 ? -1 : (short)prod);
                srcPixelOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
        }
        d.copyDataToRaster();
        return dst;
    }

    static final int clamp(int in, int maxVal) {
        return in > maxVal ? maxVal : in;
    }
}

