/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.RAFMetadataReader;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RAFImageInfo;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;

public final class RAFImageType
extends RawImageType {
    public static final RAFImageType INSTANCE = new RAFImageType();
    private static final String[] EXTENSIONS = new String[]{"raf"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "RAF";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException {
        LCByteBuffer buf = imageInfo.getByteBuffer();
        ByteOrder origOrder = buf.order();
        buf.order(ByteOrder.BIG_ENDIAN);
        int offset = buf.getInt(84);
        int length = buf.getInt(88);
        buf.order(origOrder);
        return JPEGImageType.getImageFromBuffer(buf, offset, length, null, 0, 0);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadataDirectory dir = imageInfo.getMetadata().getDirectoryFor(TIFFDirectory.class);
        if (dir == null) {
            return null;
        }
        RAFImageInfo rafInfo = (RAFImageInfo)imageInfo.getAuxiliaryInfo();
        return JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(513), rafInfo.getTIFFOffset(), dir.getValue(514), 0, 0);
    }

    @Override
    public RAFImageInfo newAuxiliaryInfo(ImageInfo imageInfo) {
        return new RAFImageInfo(imageInfo);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        RAFMetadataReader reader = new RAFMetadataReader(imageInfo);
        ImageMetadata metadata = reader.readMetadata();
        MetadataUtil.removePreviewMetadataFrom(metadata);
        MetadataUtil.removeWidthHeightFrom(metadata);
        RAFImageInfo info = (RAFImageInfo)imageInfo.getAuxiliaryInfo();
        info.setTIFFOffset(reader.getTIFFOffset());
    }

    private RAFImageType() {
    }
}

