/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.libs.InputStreamImageDataProvider;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCJPEGReader;
import com.lightcrafts.image.libs.LCJPEGWriter;
import com.lightcrafts.image.libs.OutputStreamImageDataReceiver;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.LZNDocumentProvider;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XMLUtil;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;

public final class LZNImageType
extends ImageType
implements LZNDocumentProvider {
    public static final LZNImageType INSTANCE = new LZNImageType();
    private static final String[] EXTENSIONS = new String[]{"lzn"};
    private static final String CacheTag = "Cache";

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public ICC_Profile getICCProfile(ImageInfo imageInfo) {
        return JAIContext.linearProfile;
    }

    @Override
    public PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread) throws BadImageFileException, IOException, UserCanceledException {
        XmlDocument xml = LZNImageType.getDocument(imageInfo);
        XmlNode cache = LZNImageType.getCacheNode(xml);
        byte[] bytes = cache.getData();
        if (bytes == null) {
            throw new BadImageFileException(imageInfo.getFile());
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            InputStreamImageDataProvider provider = new InputStreamImageDataProvider(in);
            LCJPEGReader reader = new LCJPEGReader(provider);
            return reader.getImage(thread, null);
        }
        catch (LCImageLibException e) {
            throw new BadImageFileException(imageInfo.getFile());
        }
    }

    @Override
    public Document getLZNDocument(ImageInfo imageInfo) throws IOException {
        return XMLUtil.readDocumentFrom(imageInfo.getFile());
    }

    @Override
    public ExportOptions newExportOptions() {
        return new ExportOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImage(ImageInfo imageInfo, RenderedImage image) throws IOException {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamImageDataReceiver receiver = new OutputStreamImageDataReceiver(buf);
            LCJPEGWriter writer = new LCJPEGWriter(receiver, 1024, image.getWidth(), image.getHeight(), image.getSampleModel().getNumBands(), 2, 90);
            writer.putImage(image);
            XmlDocument xml = LZNImageType.getDocument(imageInfo);
            XmlNode cache = LZNImageType.getCacheNode(xml);
            cache.setData(buf.toByteArray());
            FileOutputStream out = new FileOutputStream(imageInfo.getFile());
            try {
                xml.write(out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (LCImageLibException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "LZN";
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws IOException {
    }

    @Override
    public void writeMetadata(ImageInfo imageInfo) throws IOException {
    }

    private LZNImageType() {
    }

    private static XmlDocument getDocument(ImageInfo info) throws IOException {
        FileInputStream in = new FileInputStream(info.getFile());
        return new XmlDocument(in);
    }

    private static XmlNode getCacheNode(XmlDocument xml) {
        XmlNode root = xml.getRoot();
        try {
            return root.getChild(CacheTag);
        }
        catch (XMLException e) {
            return root.addChild(CacheTag);
        }
    }

    public static final class ExportOptions
    extends ImageExportOptions {
        public ExportOptions() {
            super(INSTANCE);
        }
    }
}

