/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.types.AdobeResourceParserEventHandler;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;

public class AdobeResourceParser {
    public static void parse(AdobeResourceParserEventHandler handler, File file, LCByteBuffer buf) throws BadImageFileException, IOException {
        while (buf.position() < buf.limit() - 14) {
            try {
                if (!buf.getEquals("8BIM", "ASCII")) {
                    return;
                }
            }
            catch (BufferUnderflowException e) {
                return;
            }
            try {
                String name;
                int blockID = buf.getUnsignedShort();
                byte nameLen = buf.get();
                String string = name = nameLen > 0 ? buf.getString(nameLen, "ASCII") : "";
                if ((nameLen + 1 & 1) != 0) {
                    buf.get();
                }
                int dataLength = buf.getInt();
                int savedPos = buf.position();
                boolean continueParsing = handler.gotResource(blockID, name, dataLength, file, buf);
                if (!continueParsing) {
                    return;
                }
                dataLength += dataLength & 1;
                buf.position(savedPos + dataLength);
            }
            catch (BufferUnderflowException e) {
                throw new BadImageFileException(file, (Throwable)e);
            }
        }
    }
}

