/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class UnsignedShortMetaValue
extends LongMetaValue {
    public UnsignedShortMetaValue() {
    }

    public UnsignedShortMetaValue(long ... values) {
        super(values);
    }

    public UnsignedShortMetaValue(String ... values) {
        super(values);
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_USHORT;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readInt() & 0xFFFF;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (long value : this.m_value) {
            out.writeInt((int)value);
        }
    }

    @Override
    protected long constrain(long value) {
        return value < 0L ? 0L : (value > 65536L ? 65536L : value);
    }

    @Override
    protected long parseValue(String newValue) {
        long n = Long.parseLong(newValue);
        if (n < 0L || n > 65536L) {
            throw new NumberFormatException();
        }
        return n;
    }
}

