/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class UndefinedMetaValue
extends ImageMetaValue {
    private byte[] m_value;

    public UndefinedMetaValue() {
    }

    public UndefinedMetaValue(byte[] value) {
        this.m_value = value;
        this.setNonDisplayable();
    }

    @Override
    public UndefinedMetaValue clone() {
        UndefinedMetaValue copy = (UndefinedMetaValue)super.clone();
        copy.m_value = (byte[])this.m_value.clone();
        return copy;
    }

    @Override
    public long getLongValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_UNDEFINED;
    }

    public byte[] getUndefinedValue() {
        return this.m_value;
    }

    @Override
    public int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public void setLongValue(long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element toXMP(Document xmpDoc, String nsURI, String prefix) {
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.m_value = new byte[this.readHeader(in)];
        in.readFully(this.m_value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        out.write(this.m_value);
    }

    @Override
    protected void appendValueImpl(String newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        try {
            return new String[]{new String(this.m_value, "UTF-8")};
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void setValuesImpl(String[] newValue) {
        String s;
        if (newValue.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String i : newValue) {
                sb.append(i);
            }
            s = sb.toString();
        } else {
            s = newValue[0];
        }
        try {
            this.m_value = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (byte value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            sb.append(Integer.toString(value & 0xFF));
        }
        return sb.toString();
    }
}

