/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.Locale;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.w3c.dom.Document;

public final class XMPMetadataWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeInto(ImageMetadata metadata, File xmpFile) throws IOException {
        if (xmpFile.isFile() && !xmpFile.canWrite()) {
            throw new IOException(Locale.LOCALE.get("XMPPermissionDenied"));
        }
        Document newXMPDoc = metadata.toXMP(true, false, new Class[0]);
        try {
            Document oldXMPDoc = XMLUtil.readDocumentFrom(xmpFile);
            newXMPDoc = XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc);
        }
        catch (FileNotFoundException oldXMPDoc) {
            // empty catch block
        }
        File tempFile = File.createTempFile("LZT", ".xmp", xmpFile.getParentFile());
        try {
            XMLUtil.writeDocumentTo(newXMPDoc, tempFile);
            FileUtil.renameFile(tempFile, xmpFile);
        }
        finally {
            tempFile.delete();
        }
    }

    private XMPMetadataWriter() {
    }
}

