/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.types.TIFFConstants;

public class ImageMetaTagInfo
implements Comparable {
    private final boolean m_isChangeable;
    private final int m_id;
    private final String m_name;
    private final ImageMetaType m_type;

    public ImageMetaTagInfo(int id, String name, ImageMetaType type, boolean isChangeable) {
        this.m_id = id;
        this.m_isChangeable = isChangeable;
        this.m_name = name;
        this.m_type = type;
    }

    public int compareTo(Object o) {
        if (o instanceof ImageMetaTagInfo) {
            ImageMetaTagInfo rightTagInfo = (ImageMetaTagInfo)o;
            return rightTagInfo.getID() - this.getID();
        }
        throw new IllegalArgumentException("Can not compare an ImageMetaTagInfo to a " + o.getClass().getName());
    }

    public ImageMetaValue createValue() {
        ImageMetaValue value = ImageMetaValue.create(this.m_type);
        value.setIsChangeable(this.m_isChangeable);
        value.setOwningTagID(this.m_id);
        return value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageMetaTagInfo)) {
            return false;
        }
        ImageMetaTagInfo t = (ImageMetaTagInfo)o;
        return this.m_id == t.m_id && this.m_name.equals(t.m_name) && this.m_type == t.m_type;
    }

    public int getID() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public int getSize() {
        switch (this.m_type) {
            case META_DATE: {
                return 1;
            }
            case META_UNKNOWN: {
                return 0;
            }
        }
        return TIFFConstants.TIFF_FIELD_SIZE[this.m_type.getTIFFConstant()];
    }

    public ImageMetaType getType() {
        return this.m_type;
    }

    public int hashCode() {
        return this.m_id;
    }

    public boolean isChangeable() {
        return this.m_isChangeable;
    }
}

