/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.EXIFParser;
import com.lightcrafts.image.metadata.EXIFParserEventHandler;
import com.lightcrafts.image.metadata.GPSDirectory;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.makernotes.MakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EXIFMetadataReader
extends ImageMetadataReader
implements EXIFParserEventHandler {
    protected final EXIFParser m_exifParser;
    private final Map<String, ImageMetadataDirectory> m_dirMap = new HashMap<String, ImageMetadataDirectory>();
    private int m_ifdIndex = -1;

    public EXIFMetadataReader(ImageInfo imageInfo, LCByteBuffer exifSegBuf, boolean isSubdirectory) {
        super(imageInfo, exifSegBuf);
        this.m_exifParser = new EXIFParser(this, imageInfo.getFile(), exifSegBuf, isSubdirectory);
    }

    public void readDirectory(int offset, int valueOffsetAdjustment, ImageMetadataDirectory dir) throws IOException {
        this.m_exifParser.parseDirectory(offset, valueOffsetAdjustment, dir);
    }

    @Override
    public void readAllDirectories() throws IOException {
        this.m_exifParser.parseAllDirectories();
        this.mergeEXIFDirectories();
    }

    @Override
    public void readHeader() throws BadImageFileException, IOException {
        this.m_exifParser.parseHeader();
    }

    @Override
    public void gotBadMetadata(String message) {
        this.logBadImageMetadata(message);
    }

    @Override
    public void gotBadMetadata(Throwable cause) {
        this.logBadImageMetadata(cause);
    }

    @Override
    public ImageMetadataDirectory gotDirectory() {
        ++this.m_ifdIndex;
        return this.createDirectoryFor(EXIFDirectory.class, "IFD");
    }

    @Override
    public void gotTag(int tagID, int fieldType, int numValues, int byteCount, int valueOffset, int valueOffsetAdjustment, int subdirOffset, File imageFile, LCByteBuffer buf, ImageMetadataDirectory dir) throws IOException {
        switch (tagID) {
            case 34853: {
                ImageMetadataDirectory gpsDir = this.m_metadata.getDirectoryFor(GPSDirectory.class, true);
                this.m_exifParser.parseDirectory(subdirOffset, 0, gpsDir);
                return;
            }
            case 34665: {
                this.m_exifParser.parseDirectory(subdirOffset, 0, dir);
                return;
            }
            case 40965: {
                return;
            }
            case 37500: {
                Class<? extends MakerNotesDirectory> notesClass = MakerNoteProbe.determineMakerNotesFrom(this.m_metadata);
                if (notesClass != null) {
                    ImageMetadataDirectory notesDir = this.m_metadata.getDirectoryFor(notesClass, true);
                    this.readMakerNotes(valueOffset, byteCount, notesDir);
                }
                return;
            }
            case 37510: {
                return;
            }
        }
        if (byteCount > 131072) {
            return;
        }
        ImageMetaValue value = this.m_exifParser.parseValue(tagID, fieldType, valueOffset, numValues);
        if (value != null) {
            try {
                dir.putValue(tagID, value);
            }
            catch (IllegalArgumentException e) {
                this.gotBadMetadata(e);
            }
        }
    }

    private static void copyValuesFromTo(ImageMetadataDirectory fromDir, ImageMetadataDirectory toDir) {
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = fromDir.iterator();
        block3: while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            int tagID = me.getKey();
            switch (tagID) {
                case 254: 
                case 255: 
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 262: 
                case 273: 
                case 274: 
                case 277: 
                case 278: 
                case 279: 
                case 282: 
                case 283: 
                case 284: 
                case 296: 
                case 301: 
                case 317: 
                case 319: 
                case 323: 
                case 324: 
                case 325: 
                case 330: 
                case 529: 
                case 530: 
                case 531: 
                case 532: 
                case 34665: 
                case 34675: 
                case 34853: 
                case 34856: 
                case 37121: 
                case 37122: 
                case 37500: 
                case 40961: 
                case 40962: 
                case 40963: 
                case 40965: 
                case 41730: {
                    continue block3;
                }
            }
            ImageMetaValue toValue = toDir.getValue(tagID);
            if (toValue != null) continue;
            toDir.putValue(tagID, me.getValue());
        }
    }

    private ImageMetadataDirectory createDirectoryFor(Class<? extends ImageMetadataDirectory> dirClass, String name) {
        try {
            ImageMetadataDirectory dir = dirClass.newInstance();
            dir.setOwningMetadata(this.m_metadata);
            this.m_dirMap.put(name + this.m_ifdIndex, dir);
            return dir;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void mergeEXIFDirectories() {
        ImageMetadataDirectory ifd0 = this.m_dirMap.get("IFD0");
        if (ifd0 == null) {
            return;
        }
        for (Map.Entry<String, ImageMetadataDirectory> me : this.m_dirMap.entrySet()) {
            ImageMetadataDirectory dir = me.getValue();
            if (!(dir instanceof EXIFDirectory) || dir == ifd0) continue;
            EXIFMetadataReader.copyValuesFromTo(dir, ifd0);
        }
        this.m_metadata.putDirectory(ifd0);
    }

    public void readMakerNotes(int offset, int byteCount, ImageMetadataDirectory dir) throws IOException {
        int valueOffsetAdjustment = 0;
        int[] adjustments = dir.getMakerNotesAdjustments(this.m_buf, offset);
        if (adjustments != null) {
            offset += adjustments[0];
            valueOffsetAdjustment = adjustments[1];
        }
        if (!dir.readMakerNotes(this.m_buf, offset, byteCount)) {
            ByteOrder origOrder = this.m_buf.probeOrder(offset);
            this.m_exifParser.parseDirectory(offset, valueOffsetAdjustment, dir);
            this.m_buf.order(origOrder);
        }
    }
}

