/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.libs;

import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCTIFFCommon;
import com.lightcrafts.image.libs.LCTIFFReader;
import com.lightcrafts.image.metadata.EXIFConstants;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.EXIFEncoder;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.file.OrderableRandomAccessFile;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLUtil;
import java.awt.Point;
import java.awt.color.ICC_Profile;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;

public final class LCTIFFWriter
extends LCTIFFCommon {
    private final String m_appendFileName;
    private final int m_exportHeight;
    private final int m_exportWidth;
    private final String m_fileName;
    private boolean m_hasExifMetadata;
    private final int m_resolution;
    private final int m_resolutionUnit;

    public LCTIFFWriter(String fileName, int width, int height) throws LCImageLibException, UnsupportedEncodingException {
        this(fileName, null, width, height);
    }

    public LCTIFFWriter(String fileName, int width, int height, int resolution, int resolutionUnit) throws LCImageLibException, UnsupportedEncodingException {
        this(fileName, null, width, height, resolution, resolutionUnit);
    }

    public LCTIFFWriter(String fileName, String appendFileName, int width, int height) throws LCImageLibException, UnsupportedEncodingException {
        this(fileName, appendFileName, width, height, 300, 2);
    }

    public LCTIFFWriter(String fileName, String appendFileName, int width, int height, int resolution, int resolutionUnit) throws LCImageLibException, UnsupportedEncodingException {
        this.m_fileName = fileName;
        this.m_appendFileName = appendFileName;
        this.m_exportWidth = width;
        this.m_exportHeight = height;
        this.m_resolution = resolution;
        this.m_resolutionUnit = resolutionUnit;
        this.openForWriting(fileName);
        if (this.m_nativePtr == 0L) {
            throw new LCImageLibException("Could not open " + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImageTiled(RenderedImage image, ProgressThread thread) throws IOException, LCImageLibException {
        try {
            this.writeImageTiled(image, thread);
            if (this.m_appendFileName != null) {
                this.append(this.m_appendFileName);
            }
            this.dispose();
            if (this.m_hasExifMetadata) {
                LCTIFFWriter.fixEXIFMetadata(this.m_fileName);
            }
        }
        finally {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImageStriped(RenderedImage image, ProgressThread thread) throws IOException, LCImageLibException {
        try {
            this.writeImageStriped(image, thread);
            if (this.m_appendFileName != null) {
                this.append(this.m_appendFileName);
            }
            this.dispose();
            if (this.m_hasExifMetadata) {
                LCTIFFWriter.fixEXIFMetadata(this.m_fileName);
            }
        }
        finally {
            this.dispose();
        }
    }

    public void putMetadata(ImageMetadata metadata) throws IOException, LCImageLibException {
        ImageMetadataDirectory iptcDir;
        ImageMetadataDirectory exifDir;
        ImageMetadataDirectory tiffDir = (metadata = metadata.prepForExport(TIFFImageType.INSTANCE, this.m_exportWidth, this.m_exportHeight, this.m_resolution, this.m_resolutionUnit, false)).getDirectoryFor(TIFFDirectory.class);
        if (tiffDir != null) {
            Iterator<Map.Entry<Integer, ImageMetaValue>> i = tiffDir.iterator();
            while (i.hasNext()) {
                Map.Entry<Integer, ImageMetaValue> me = i.next();
                int tagID = me.getKey();
                ImageMetaValue value = me.getValue();
                switch (tagID) {
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 285: 
                    case 305: 
                    case 306: 
                    case 315: 
                    case 316: 
                    case 333: 
                    case 337: 
                    case 33432: {
                        this.setStringField(tagID, value.getStringValue());
                        break;
                    }
                    case 296: 
                    case 18246: {
                        this.setIntField(tagID, value.getIntValue());
                        break;
                    }
                    case 282: 
                    case 283: {
                        this.setFloatField(tagID, value.getFloatValue());
                    }
                }
            }
        }
        if ((exifDir = metadata.getDirectoryFor(EXIFDirectory.class)) != null) {
            ByteBuffer exifBuf = EXIFEncoder.encode(metadata, false);
            this.setByteField(34377, exifBuf.array());
            this.m_hasExifMetadata = true;
        }
        if ((iptcDir = metadata.getDirectoryFor(IPTCDirectory.class)) != null) {
            byte[] iptcBuf = ((IPTCDirectory)iptcDir).encode(false);
            if (iptcBuf != null) {
                this.setByteField(33723, iptcBuf);
            }
            Document xmpDoc = metadata.toXMP(false, true, IPTCDirectory.class);
            byte[] xmpBuf = XMLUtil.encodeDocument(xmpDoc, false);
            this.setByteField(700, xmpBuf);
        }
    }

    public native boolean setByteField(int var1, byte[] var2) throws LCImageLibException;

    public native boolean setFloatField(int var1, float var2) throws LCImageLibException;

    public void setICCProfile(ICC_Profile iccProfile) throws LCImageLibException {
        this.setByteField(34675, iccProfile.getData());
    }

    public native boolean setIntField(int var1, int var2) throws LCImageLibException;

    public boolean setStringField(int tagID, String value) throws LCImageLibException, UnsupportedEncodingException {
        byte[] valueUtf8 = (value + '\u0000').getBytes("UTF-8");
        return this.setStringField(tagID, valueUtf8);
    }

    public native boolean setStringField(int var1, byte[] var2) throws LCImageLibException;

    private boolean append(String fileName) throws IOException {
        byte[] fileNameUtf8 = (fileName + '\u0000').getBytes("UTF-8");
        return this.append(fileNameUtf8);
    }

    private native boolean append(byte[] var1);

    private native int computeTile(int var1, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixEXIFMetadata(String fileName) throws IOException {
        OrderableRandomAccessFile file = new OrderableRandomAccessFile(fileName, "rw");
        try {
            if (file.readShort() == 18761) {
                file.order(ByteOrder.LITTLE_ENDIAN);
            }
            file.seek(4L);
            int ifdOffset = file.readInt();
            while (ifdOffset > 0) {
                file.seek(ifdOffset);
                int entryCount = file.readUnsignedShort();
                for (int entry = 0; entry < entryCount; ++entry) {
                    int entryOffset = TIFFMetadataReader.calcIFDEntryOffset(ifdOffset, entry);
                    file.seek(entryOffset);
                    int tagID = file.readUnsignedShort();
                    if (tagID != 34377) continue;
                    file.seek(file.getFilePointer() - 2L);
                    file.writeShort(34665);
                    file.writeShort(4);
                    file.writeInt(1);
                    int subdirOffset = file.readInt();
                    LCTIFFWriter.fixEXIFDirectory(file, subdirOffset, 0);
                    return;
                }
                ifdOffset = file.readInt();
            }
        }
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void fixEXIFDirectory(OrderableRandomAccessFile file, long dirOffset, int parentDirSize) throws IOException {
        file.seek(dirOffset);
        int entryCount = file.readUnsignedShort();
        for (int entry = 0; entry < entryCount; ++entry) {
            int entryOffset = TIFFMetadataReader.calcIFDEntryOffset((int)dirOffset, entry);
            file.seek(entryOffset);
            int tagID = file.readUnsignedShort();
            int fieldType = file.readUnsignedShort();
            int numValues = file.readInt();
            int byteCount = numValues * EXIFConstants.EXIF_FIELD_SIZE[fieldType];
            if (byteCount <= 4 && tagID != 34665) continue;
            int valueOffset = file.readInt();
            file.seek(file.getFilePointer() - 4L);
            file.writeInt(valueOffset += (int)dirOffset + parentDirSize);
            switch (tagID) {
                case 34665: {
                    int exifIFDSize = 2 + entryCount * 12 + 4;
                    LCTIFFWriter.fixEXIFDirectory(file, valueOffset, -exifIFDSize);
                }
            }
        }
    }

    private void openForWriting(String fileName) throws LCImageLibException, UnsupportedEncodingException {
        byte[] fileNameUtf8 = (fileName + '\u0000').getBytes("UTF-8");
        this.openForWriting(fileNameUtf8);
    }

    private native void openForWriting(byte[] var1) throws LCImageLibException;

    private void writeImageStriped(RenderedImage image, ProgressThread thread) throws LCImageLibException {
        int[] nArray;
        ProgressIndicator indicator;
        int dataType = image.getSampleModel().getDataType();
        int bands = image.getSampleModel().getNumBands();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int stripHeight = 32;
        this.setIntField(258, dataType == 0 ? 8 : 16);
        this.setIntField(256, imageWidth);
        this.setIntField(257, imageHeight);
        this.setIntField(262, bands == 4 ? 5 : (bands == 3 ? 2 : 1));
        this.setIntField(284, 1);
        this.setIntField(278, 32);
        this.setIntField(277, bands);
        if (thread != null) {
            indicator = thread.getProgressIndicator();
            if (indicator != null) {
                indicator.setMaximum(imageHeight);
            }
        } else {
            indicator = null;
        }
        int type = dataType == 0 ? 0 : 1;
        if (bands == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (bands == 3) {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        } else {
            int[] nArray4 = new int[4];
            nArray4[0] = 0;
            nArray4[1] = 1;
            nArray4[2] = 2;
            nArray = nArray4;
            nArray4[3] = 3;
        }
        WritableRaster outBuffer = Raster.createInterleavedRaster(type, imageWidth, 32, bands * imageWidth, bands, nArray, new Point(0, 0));
        int stripIndex = 0;
        for (int y = 0; y < imageHeight; y += 32) {
            int written;
            DataBuffer db;
            if (thread != null && thread.isCanceled()) {
                return;
            }
            int currentStripHeight = Math.min(32, imageHeight - y);
            WritableRaster raster = outBuffer.createWritableChild(0, 0, imageWidth, currentStripHeight, 0, y, null);
            if (image instanceof PlanarImage) {
                ((PlanarImage)image).getTiles(((PlanarImage)image).getTileIndices(raster.getBounds()));
            }
            image.copyData(raster);
            ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
            int[] offsets = csm.getBandOffsets();
            int offset = offsets[0];
            for (int i = 1; i < offsets.length; ++i) {
                offset = Math.min(offset, offsets[i]);
            }
            if (dataType == 0) {
                db = (DataBufferByte)raster.getDataBuffer();
                written = this.writeStripByte(stripIndex, ((DataBufferByte)db).getData(), offset, bands * imageWidth * currentStripHeight);
                if (written != bands * imageWidth * currentStripHeight) {
                    throw new LCImageLibException("something is wrong: " + written + " != " + bands * imageWidth * currentStripHeight);
                }
            } else {
                db = (DataBufferUShort)raster.getDataBuffer();
                written = this.writeStripShort(stripIndex, ((DataBufferUShort)db).getData(), offset, 2 * bands * imageWidth * currentStripHeight);
                if (written != 2 * bands * imageWidth * currentStripHeight) {
                    throw new LCImageLibException("something is wrong: " + written + " != " + 2 * bands * imageWidth * currentStripHeight);
                }
            }
            ++stripIndex;
            if (indicator == null) continue;
            indicator.incrementBy(currentStripHeight);
        }
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
    }

    private void writeImageTiled(RenderedImage image, ProgressThread thread) throws LCImageLibException {
        ProgressIndicator indicator;
        int dataType = image.getSampleModel().getDataType();
        this.setIntField(256, image.getWidth());
        this.setIntField(257, image.getHeight());
        this.setIntField(258, dataType == 0 ? 8 : 16);
        this.setIntField(277, image.getSampleModel().getNumBands());
        this.setIntField(284, 1);
        this.setIntField(262, 2);
        this.setIntField(322, image.getTileWidth());
        this.setIntField(323, image.getTileHeight());
        if (thread != null) {
            indicator = thread.getProgressIndicator();
            if (indicator != null) {
                indicator.setMaximum(image.getNumXTiles() * image.getNumYTiles());
            }
        } else {
            indicator = null;
        }
        for (int tileX = 0; tileX < image.getNumXTiles(); ++tileX) {
            for (int tileY = 0; tileY < image.getNumYTiles(); ++tileY) {
                int bytesWritten;
                Object[] buffer;
                if (thread != null && thread.isCanceled()) {
                    return;
                }
                int tileIndex = this.computeTile(tileX * image.getTileWidth(), tileY * image.getTileHeight(), 0, 0);
                Raster tile = image.getTile(tileX, tileY);
                if (dataType == 0) {
                    buffer = ((DataBufferByte)tile.getDataBuffer()).getData();
                    bytesWritten = this.writeTileByte(tileIndex, (byte[])buffer, 0L, buffer.length);
                    if (bytesWritten != buffer.length) {
                        throw new LCImageLibException("something is wrong: " + bytesWritten + " != " + buffer.length);
                    }
                } else {
                    buffer = ((DataBufferUShort)tile.getDataBuffer()).getData();
                    bytesWritten = this.writeTileShort(tileIndex, (short[])buffer, 0L, buffer.length * 2);
                    if (bytesWritten != buffer.length * 2) {
                        throw new LCImageLibException("something is wrong: " + bytesWritten + " != " + buffer.length * 2);
                    }
                }
                if (indicator == null) continue;
                indicator.incrementBy(1);
            }
        }
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
    }

    private native int writeStripByte(int var1, byte[] var2, long var3, int var5) throws LCImageLibException;

    private native int writeStripShort(int var1, short[] var2, long var3, int var5) throws LCImageLibException;

    private native int writeTileByte(int var1, byte[] var2, long var3, int var5) throws LCImageLibException;

    private native int writeTileShort(int var1, short[] var2, long var3, int var5) throws LCImageLibException;

    public static void main(String[] args) throws Exception {
        try {
            LCTIFFReader tiff = new LCTIFFReader(args[0]);
            PlanarImage image = tiff.getImage(null);
            LCTIFFWriter writer = new LCTIFFWriter("/Users/pjl/Desktop/out.tiff", args[1], image.getWidth(), image.getHeight());
            writer.setStringField(305, Version.getApplicationName());
            writer.putImageStriped((RenderedImage)image, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

