/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.libs;

import com.lightcrafts.image.libs.LCImageDataProvider;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.types.AdobeJPEGSegmentFilter;
import com.lightcrafts.image.types.JPEGImageInfo;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class LCJPEGReader {
    public static final int DEFAULT_BUF_SIZE = 32768;
    private int m_colorsPerPixel;
    private int m_colorSpace;
    private boolean m_hasAdobeSegment;
    private int m_height;
    private PlanarImage m_image;
    private long m_nativePtr;
    private int m_width;

    public LCJPEGReader(String fileName) throws FileNotFoundException, LCImageLibException, UnsupportedEncodingException {
        this(fileName, 0, 0, null);
    }

    public LCJPEGReader(String fileName, int maxWidth, int maxHeight, JPEGImageInfo jpegInfo) throws FileNotFoundException, LCImageLibException, UnsupportedEncodingException {
        this.openForReading(fileName, maxWidth, maxHeight);
        if (jpegInfo != null) {
            ByteBuffer segBuf = jpegInfo.getFirstSegmentFor((byte)-18, new AdobeJPEGSegmentFilter());
            this.m_hasAdobeSegment = segBuf != null;
        }
    }

    public LCJPEGReader(LCImageDataProvider provider) throws LCImageLibException {
        this(provider, 0, 0);
    }

    public LCJPEGReader(LCImageDataProvider provider, int maxWidth, int maxHeight) throws LCImageLibException {
        this.beginRead(provider, 32768, maxWidth, maxHeight);
    }

    public LCJPEGReader(LCImageDataProvider provider, int bufSize) throws LCImageLibException {
        this.beginRead(provider, bufSize, 0, 0);
    }

    public LCJPEGReader(LCImageDataProvider provider, int bufSize, int maxWidth, int maxHeight) throws LCImageLibException {
        this.beginRead(provider, bufSize, maxWidth, maxHeight);
    }

    public native void dispose() throws LCImageLibException;

    public int getColorsPerPixel() {
        return this.m_colorsPerPixel;
    }

    public int getColorSpace() {
        return this.m_colorSpace;
    }

    public int getHeight() {
        return this.m_height;
    }

    public PlanarImage getImage() throws LCImageLibException, UserCanceledException {
        return this.getImage(null, null);
    }

    public synchronized PlanarImage getImage(ColorSpace cs) throws LCImageLibException, UserCanceledException {
        return this.getImage(null, cs);
    }

    public synchronized PlanarImage getImage(ProgressThread thread, ColorSpace cs) throws LCImageLibException, UserCanceledException {
        if (this.m_image == null) {
            boolean userCanceled = false;
            try {
                this.readImage(thread, cs);
            }
            catch (UserCanceledException e) {
                userCanceled = true;
                throw e;
            }
            finally {
                block11: {
                    try {
                        this.dispose();
                    }
                    catch (LCImageLibException e) {
                        if (userCanceled) break block11;
                        throw e;
                    }
                }
            }
        }
        return this.m_image;
    }

    public int getWidth() {
        return this.m_width;
    }

    public synchronized native int readScanLines(byte[] var1, long var2, int var4) throws LCImageLibException;

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private native void beginRead(LCImageDataProvider var1, int var2, int var3, int var4) throws LCImageLibException;

    private void openForReading(String fileName, int maxWidth, int maxHeight) throws FileNotFoundException, LCImageLibException, UnsupportedEncodingException {
        byte[] fileNameUtf8 = (fileName + '\u0000').getBytes("UTF-8");
        this.openForReading(fileNameUtf8, maxWidth, maxHeight);
    }

    private native void openForReading(byte[] var1, int var2, int var3) throws FileNotFoundException, LCImageLibException;

    private void readImage(ProgressThread thread, ColorSpace cs) throws LCImageLibException, UserCanceledException {
        ProgressIndicator indicator = null;
        if (thread != null) {
            indicator = thread.getProgressIndicator();
        }
        if (indicator != null) {
            indicator.setMaximum(this.m_height);
        }
        if (cs == null) {
            cs = this.m_colorsPerPixel == 1 ? JAIContext.gray22ColorSpace : (this.m_colorsPerPixel == 3 ? JAIContext.sRGBColorSpace : JAIContext.CMYKColorSpace);
        }
        ComponentColorModel ccm = new ComponentColorModel(cs, false, false, 1, 0);
        SampleModel jpegTsm = ccm.createCompatibleSampleModel(this.m_width, 512);
        DataBufferByte db = new DataBufferByte(this.m_colorsPerPixel * this.m_width * 512);
        SampleModel tsm = ccm.createCompatibleSampleModel(512, 512);
        ImageLayout layout = new ImageLayout(0, 0, this.m_width, this.m_height, 0, 0, 512, 512, tsm, (ColorModel)ccm);
        CachedImage image = new CachedImage(layout, JAIContext.fileCache);
        int tileY = 0;
        int totalLinesRead = 0;
        while (totalLinesRead < this.m_height) {
            if (thread != null && thread.isCanceled()) {
                throw new UserCanceledException();
            }
            int tileHeight = Math.min(512, this.m_height - totalLinesRead);
            WritableRaster raster = Raster.createWritableRaster(jpegTsm, db, new Point(0, tileY * 512));
            int linesRead = this.readScanLines(db.getData(), 0L, tileHeight);
            if (linesRead <= 0) {
                System.out.println("Problem with readScanLines, returned: " + linesRead);
                break;
            }
            if (this.m_hasAdobeSegment && this.m_colorsPerPixel == 4) {
                byte[] data = db.getData();
                for (int i = 0; i < data.length; ++i) {
                    data[i] = ~data[i];
                }
            }
            totalLinesRead += linesRead;
            ++tileY;
            image.setData(raster);
            if (indicator == null) continue;
            indicator.incrementBy(linesRead);
        }
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
        this.m_image = image;
    }

    static {
        System.loadLibrary("LCJPEG");
    }
}

