/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.export;

import com.lightcrafts.image.export.ImageExportOption;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.IOException;

public class BooleanExportOption
extends ImageExportOption {
    private boolean m_value;

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof BooleanExportOption)) {
            return false;
        }
        BooleanExportOption b = (BooleanExportOption)o;
        return b.getName().equals(this.getName()) && b.getValue() == this.getValue();
    }

    public boolean getValue() {
        return this.m_value;
    }

    public void setValue(boolean newValue) {
        this.m_value = newValue;
    }

    @Override
    public void setValue(String newValue) {
        this.m_value = Boolean.valueOf(newValue);
        if (this.m_value) {
            return;
        }
        try {
            this.m_value = Integer.parseInt(newValue) != 0;
        }
        catch (NumberFormatException e) {
            this.m_value = false;
        }
    }

    @Override
    public void save(XmlNode node) {
        node = node.addChild(this.getName());
        String value = Boolean.toString(this.getValue());
        node.setAttribute("value", value);
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        node = node.getChild(this.getName());
        this.m_value = Boolean.valueOf(node.getAttribute("value"));
    }

    @Override
    public void readFrom(ImageExportOptionReader r) throws IOException {
        r.read(this);
    }

    @Override
    public void writeTo(ImageExportOptionWriter w) throws IOException {
        w.write(this);
    }

    protected BooleanExportOption(String name, boolean defaultValue, ImageExportOptions options) {
        super(name, options);
        this.m_value = defaultValue;
    }
}

