/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.ui.toolkit.journal.JournalDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;

public final class WindowMenu
extends UpdatableDisposableMenu {
    private static LinkedList<WindowMenu> Menus = new LinkedList();

    WindowMenu(ComboFrame frame) {
        super(frame, "Window");
        Menus.add(this);
        JMenuItem minItem = MenuFactory.createMenuItem("Minimize");
        minItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboFrame frame = WindowMenu.this.getComboFrame();
                frame.setExtendedState(1);
            }
        });
        minItem.setEnabled(frame != null);
        this.put("minItem", minItem);
        JMenuItem maxItem = MenuFactory.createMenuItem("Maximize");
        maxItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboFrame frame = WindowMenu.this.getComboFrame();
                int state = frame.getExtendedState();
                if ((state & 6) != 0) {
                    frame.setExtendedState(state - 6);
                } else {
                    frame.setExtendedState(6);
                }
            }
        });
        maxItem.setEnabled(frame != null);
        this.put("maxItem", maxItem);
        JMenuItem allItem = MenuFactory.createMenuItem("AllToFront");
        allItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WindowMenu windowMenu : Menus) {
                    ComboFrame window = windowMenu.getComboFrame();
                    if (window == null) continue;
                    window.toFront();
                }
            }
        });
        this.put("allItem", allItem);
        if (System.getProperty("lightcrafts.debug") != null || System.getProperty("lightcrafts.journal") != null) {
            this.addSeparator();
            JMenuItem journalItem = new JMenuItem("Event Journal");
            journalItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboFrame frame = WindowMenu.this.getComboFrame();
                    JournalDialog.showJournalDialog(frame);
                }
            });
            this.put("journalItem", journalItem);
        }
        this.update();
    }

    public static void updateAll() {
        for (WindowMenu menu : Menus) {
            menu.update();
        }
    }

    @Override
    void update() {
        JMenuItem journalItem;
        JMenuItem minItem = (JMenuItem)this.get("minItem");
        JMenuItem maxItem = (JMenuItem)this.get("maxItem");
        JMenuItem allItem = (JMenuItem)this.get("allItem");
        this.removeAll();
        int n = 0;
        while (this.containsKey("frame" + n)) {
            this.remove("frame" + n);
            ++n;
        }
        this.add(minItem);
        this.add(maxItem);
        this.addSeparator();
        this.add(allItem);
        this.addSeparator();
        List<ComboFrame> current = Application.getCurrentFrames();
        int index = 0;
        for (ComboFrame frame : current) {
            String title = frame.getTitle();
            JMenuItem menuItem = new JMenuItem(title);
            final String frameKey = "frame" + index++;
            this.put(frameKey, frame);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Frame frame = (Frame)WindowMenu.this.get(frameKey);
                    frame.toFront();
                }
            });
            this.add(menuItem);
        }
        if (current.isEmpty()) {
            JMenuItem emptyItem = MenuFactory.createMenuItem("NoWindow");
            emptyItem.setEnabled(false);
            this.add(emptyItem);
        }
        if ((journalItem = (JMenuItem)this.get("journalItem")) != null) {
            this.addSeparator();
            this.add(journalItem);
        }
    }

    public static void destroyMenu(WindowMenu menu) {
        menu.dispose();
        Menus.remove(menu);
    }
}

