/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.WebBrowser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

class HelpMenu
extends UpdatableDisposableMenu {
    HelpMenu(ComboFrame frame) {
        super(frame, "Help");
        JMenuItem menuItem = MenuFactory.createMenuItem("LightZoneHelp");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.getPlatform().showHelpTopic(null);
            }
        });
        this.add(menuItem);
        menuItem = MenuFactory.createMenuItem("VideoLearningCenter");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = Version.getVideoLearningCenterURL();
                WebBrowser.browse(url.toString());
            }
        });
        this.add(menuItem);
        this.add(new JSeparator());
        menuItem = MenuFactory.createMenuItem("ProductPage");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = Version.getApplicationURL();
                if (url != null) {
                    WebBrowser.browse(url.toString());
                }
            }
        });
        this.add(menuItem);
        if (Platform.getType() != Platform.MacOSX) {
            menuItem = MenuFactory.createMenuItem("About");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Application.showAbout();
                }
            });
            this.add(new JSeparator());
            this.add(menuItem);
        }
    }
}

