/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.BrowserExportMenuItem;
import com.lightcrafts.app.menu.BrowserPrintMenuItem;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.RescanMenuItem;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserActions;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.EditorMode;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class BrowserMenu
extends UpdatableDisposableMenu {
    private WeakReference<AbstractImageBrowser> browserRef = new WeakReference<Object>(null);
    private JMenu templateItem;
    private boolean wasTemplatesInitialized;
    private boolean wasVisible;

    BrowserMenu(ComboFrame frame) {
        super(frame, "Browser");
        if (frame == null) {
            this.addNoFrameAction();
        }
    }

    @Override
    void update() {
        ComboFrame frame = this.getComboFrame();
        if (frame == null) {
            return;
        }
        AbstractImageBrowser newBrowser = frame.getBrowser();
        AbstractImageBrowser oldBrowser = (AbstractImageBrowser)this.browserRef.get();
        boolean isVisible = frame.isBrowserVisible();
        if (newBrowser != oldBrowser || isVisible != this.wasVisible) {
            this.removeAll();
            if (isVisible) {
                this.addBrowserActions();
            } else {
                this.addNoBrowserAction();
            }
            this.browserRef = new WeakReference<AbstractImageBrowser>(newBrowser);
            this.wasVisible = isVisible;
        }
        if (isVisible) {
            ArrayList<File> selection = newBrowser.getSelectedFiles();
            if (this.wasTemplatesInitialized) {
                this.templateItem.setEnabled(!selection.isEmpty());
            }
        }
        super.update();
    }

    private void addBrowserActions() {
        ComboFrame frame = this.getComboFrame();
        AbstractImageBrowser browser = frame.getBrowser();
        ImageBrowserActions actions = browser.getActions();
        this.add(actions.getLeftAction());
        this.add(actions.getRightAction());
        this.addRatingMenu();
        this.addSeparator();
        this.add(actions.getSelectLatestAction());
        this.add(actions.getSelectAllAction());
        this.add(actions.getSelectNoneAction());
        this.addSeparator();
        this.add(actions.getEditAction());
        this.add(actions.getShowFileInFolderAction());
        this.add(actions.getRenameAction());
        this.add(actions.getTrashAction());
        this.addSeparator();
        this.add(actions.getCopyAction());
        this.add(actions.getPasteAction());
        this.addTemplatesMenu();
        this.addSeparator();
        this.add(new BrowserExportMenuItem(frame));
        this.add(new BrowserPrintMenuItem(frame));
        this.addSeparator();
        this.add(actions.getRefreshAction());
        this.add(new RescanMenuItem(frame));
        this.addSeparator();
        this.add(actions.getShowHideTypesAction());
    }

    private void addNoBrowserAction() {
        JMenuItem noBrowser = MenuFactory.createMenuItem("NoBrowser");
        final ComboFrame frame = this.getComboFrame();
        noBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Editor editor = frame.getEditor();
                        editor.setMode(EditorMode.ARROW);
                        frame.showBrowserPerspective();
                    }
                });
            }
        });
        this.add(noBrowser);
    }

    private void addNoFrameAction() {
        JMenuItem noFrame = MenuFactory.createMenuItem("NoFrame");
        noFrame.setEnabled(false);
        this.add(noFrame);
    }

    private void addTemplatesMenu() {
        this.templateItem = MenuFactory.createMenu("BrowserTemplate");
        try {
            List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
            for (final TemplateKey key : keys) {
                JMenuItem item = new JMenuItem(key.toString());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ComboFrame frame = BrowserMenu.this.getComboFrame();
                        AbstractImageBrowser browser = frame.getBrowser();
                        ArrayList<File> list = browser.getSelectedFiles();
                        if (list.size() > 0) {
                            File[] files = list.toArray(new File[0]);
                            Application.applyTemplate(frame, files, key);
                        }
                    }
                });
                this.templateItem.add(item);
                this.wasTemplatesInitialized = true;
            }
        }
        catch (TemplateDatabase.TemplateException e) {
            System.out.println("Couldn't initialize browser templates menu");
            e.printStackTrace();
            this.templateItem.setEnabled(false);
            this.wasTemplatesInitialized = false;
        }
        this.templateItem.setEnabled(false);
        this.add(this.templateItem);
    }

    private void addRatingMenu() {
        ComboFrame frame = this.getComboFrame();
        AbstractImageBrowser browser = frame.getBrowser();
        ImageBrowserActions actions = browser.getActions();
        JMenu menu = MenuFactory.createMenu("Rate");
        for (Action action : actions.getRatingActions()) {
            JMenuItem item = menu.add(action);
            String name = (String)action.getValue("Name");
            if (Platform.getType() != Platform.Windows) continue;
            char star = '\u2605';
            if (name.length() <= 0 || name.charAt(0) != star) continue;
            item.setFont(new Font("Serif", 0, 14));
        }
        menu.addSeparator();
        menu.add(actions.getClearRatingAction());
        this.add(menu);
    }
}

