/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.splash.SplashWindow;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.FileCacheFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;

class StartupCrash {
    private static final String StartupKey = "StartupSuccessful";

    StartupCrash() {
    }

    static void startupStarted() {
        Preferences prefs = Preferences.userRoot().node("/com/lightcrafts/app");
        prefs.putBoolean(StartupKey, false);
        try {
            prefs.sync();
        }
        catch (BackingStoreException e) {
            System.err.println("Couldn't access Preferences in StartupCrash");
            e.printStackTrace();
        }
    }

    static void startupEnded() {
        Preferences prefs = Preferences.userRoot().node("/com/lightcrafts/app");
        prefs.putBoolean(StartupKey, true);
    }

    static void checkLastStartupSuccessful() {
        Preferences prefs = Preferences.userRoot().node("/com/lightcrafts/app");
        boolean wasSuccessful = prefs.getBoolean(StartupKey, true);
        if (!wasSuccessful) {
            SplashWindow.disposeSplash();
            StartupCrash.showResetDialog(true);
        }
    }

    private static void showResetDialog(boolean timeout) {
        String helpButtonText = Locale.LOCALE.get("StartupErrorHelpOption");
        String resetButtonText = Locale.LOCALE.get("StartupErrorResetOption");
        String dontResetButtonText = Locale.LOCALE.get("StartupErrorDontResetOption");
        JOptionPane pane = new JOptionPane(StartupCrash.createText(Locale.LOCALE.get("StartupErrorMessage")), 2, 2, null, new Object[]{helpButtonText, resetButtonText, dontResetButtonText}, dontResetButtonText);
        final JDialog dialog = pane.createDialog(Locale.LOCALE.get("StartupErrorHelpDialogTitle"));
        if (timeout) {
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (helpButtonText.equals(selectedValue)) {
            StartupCrash.showHelpDialog();
            dialog.dispose();
            StartupCrash.showResetDialog(false);
        } else if (resetButtonText.equals(selectedValue)) {
            JButton help = new JButton(helpButtonText);
            help.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    StartupCrash.showHelpDialog();
                }
            });
            int option = JOptionPane.showOptionDialog(null, StartupCrash.createText(Locale.LOCALE.get("ResetWarningMajor")), Locale.LOCALE.get("ResetDialogTitle"), 2, 2, null, new Object[]{help, resetButtonText, dontResetButtonText}, dontResetButtonText);
            if (option != 1) {
                return;
            }
            boolean success = true;
            try {
                Preferences root = Preferences.userRoot();
                Preferences node = root.node("/com/lightcrafts");
                node.removeNode();
            }
            catch (BackingStoreException e) {
                System.err.println("StartupCrash failed to reset Preferences");
                StartupCrash.showErrorDialog(e);
                success = false;
            }
            try {
                FileCache cache = FileCacheFactory.getGlobalCache();
                if (cache != null) {
                    cache.clear();
                }
            }
            catch (IOException e) {
                System.err.println("StartupCrach failed to clear FileCache");
                StartupCrash.showErrorDialog(e);
                success = false;
            }
            if (success) {
                StartupCrash.showSuccessDialog();
            }
        }
    }

    private static void showHelpDialog() {
        JTextArea text = StartupCrash.createText(Locale.LOCALE.get("StartupErrorHelpText1") + '\n' + '\n' + Locale.LOCALE.get("StartupErrorHelpText2") + '\n' + Locale.LOCALE.get("StartupErrorHelpText3") + '\n' + Locale.LOCALE.get("StartupErrorHelpText4") + '\n' + Locale.LOCALE.get("StartupErrorHelpText5") + '\n' + Locale.LOCALE.get("StartupErrorHelpText6") + '\n' + Locale.LOCALE.get("StartupErrorHelpText7") + '\n' + '\n' + Locale.LOCALE.get("StartupErrorHelpText8"));
        JOptionPane.showMessageDialog(null, text, Locale.LOCALE.get("StartupErrorHelpDialogTitle"), 1);
    }

    private static void showSuccessDialog() {
        JOptionPane.showMessageDialog(null, Locale.LOCALE.get("ResetSuccessMessage"), Locale.LOCALE.get("ResetDialogTitle"), 1);
    }

    private static void showErrorDialog(Throwable t) {
        JOptionPane.showMessageDialog(null, Locale.LOCALE.get("ResetErrorMessage") + ": " + t.getClass().getName() + " " + t.getMessage(), Locale.LOCALE.get("ResetErrorDialogTitle"), 0);
    }

    private static JTextArea createText(String message) {
        JTextArea text = TextAreaFactory.createTextArea(message, 40);
        text.setBackground(new JPanel().getBackground());
        return text;
    }

    public static void main(String[] args) {
        boolean shouldCrash = false;
        StartupCrash.checkLastStartupSuccessful();
        StartupCrash.startupStarted();
        if (shouldCrash) {
            System.exit(0);
        }
        StartupCrash.startupEnded();
    }
}

