/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Locale;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.ui.editor.assoc.DocumentDatabase;
import com.lightcrafts.ui.editor.assoc.DocumentDatabaseListener;
import com.lightcrafts.ui.toolkit.ButtonIcon;
import com.lightcrafts.ui.toolkit.MenuButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;

class RelatedDocsMenu
extends MenuButton
implements DocumentDatabaseListener {
    private static Icon Icon;
    private ComboFrame frame;
    private File imageFile;

    RelatedDocsMenu(ComboFrame frame, ImageMetadata meta) {
        this.frame = frame;
        this.setIcon(Icon);
        ImageMetadataDirectory coreDir = meta.getDirectoryFor(CoreDirectory.class);
        ImageMetaValue fileValue = coreDir.getValue(3);
        ImageMetaValue dirValue = coreDir.getValue(2);
        this.imageFile = new File(dirValue.toString(), fileValue.toString());
        this.updateFromDatabase();
        DocumentDatabase.addListener(this);
    }

    RelatedDocsMenu() {
        this.setEnabled(false);
    }

    @Override
    public void docFilesChanged(File imageFile) {
        this.updateFromDatabase();
    }

    private void updateFromDatabase() {
        this.clear();
        JMenuItem origItem = new JMenuItem("Original (" + this.imageFile.getName() + ")");
        origItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Application.open(RelatedDocsMenu.this.frame, RelatedDocsMenu.this.imageFile);
            }
        });
        this.add(origItem);
        List<File> docs = DocumentDatabase.getDocumentsForImage(this.imageFile);
        Comparator<File> alphaFileComparator = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        };
        Collections.sort(docs, alphaFileComparator);
        for (final File file : docs) {
            JMenuItem item = new JMenuItem(file.getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Application.open(RelatedDocsMenu.this.frame, file);
                }
            });
            this.add(item);
        }
        boolean empty = docs.isEmpty();
        this.setEnabled(!empty);
    }

    static {
        String versions = Locale.LOCALE.get("VersionsLabel");
        Icon = new ButtonIcon(versions, 0, 0);
    }
}

