/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SaturatedColorScheme
extends BaseColorScheme {
    private double saturationFactor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public SaturatedColorScheme(ColorScheme origScheme, double saturationFactor) {
        this.saturationFactor = saturationFactor;
        this.origScheme = origScheme;
        this.foregroundColor = origScheme.getForegroundColor();
        this.mainUltraDarkColor = SubstanceColorUtilities.getSaturatedColor(origScheme.getUltraDarkColor(), saturationFactor);
        this.mainDarkColor = SubstanceColorUtilities.getSaturatedColor(origScheme.getDarkColor(), saturationFactor);
        this.mainMidColor = SubstanceColorUtilities.getSaturatedColor(origScheme.getMidColor(), saturationFactor);
        this.mainLightColor = SubstanceColorUtilities.getSaturatedColor(origScheme.getLightColor(), saturationFactor);
        this.mainExtraLightColor = SubstanceColorUtilities.getSaturatedColor(origScheme.getExtraLightColor(), saturationFactor);
        this.mainUltraLightColor = SubstanceColorUtilities.getSaturatedColor(origScheme.getUltraLightColor(), saturationFactor);
        this.id = "Saturated " + SubstanceCoreUtilities.getSchemeId(origScheme) + saturationFactor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getSaturationFactor() {
        return this.saturationFactor;
    }
}

