/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstancePopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate = new SubstanceFillBackgroundDelegate();

    public static ComponentUI createUI(JComponent c) {
        return new SubstancePopupMenuSeparatorUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        try {
            JSeparator sep = (JSeparator)c;
            this.fillBackgroundDelegate.update(graphics, c);
            int xOffset = MenuUtilities.getTextOffset((Graphics)graphics, sep.getParent());
            Dimension s = c.getSize();
            if (c.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceCoreUtilities.getActiveScheme(sep);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, xOffset, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite((Component)sep, 0.7f));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, xOffset - 2, c.getHeight());
                }
                graphics.setComposite(TransitionLayout.getAlphaComposite(sep));
                graphics.setColor(c.getForeground());
                graphics.drawLine(xOffset, 1, s.width, 1);
                graphics.setColor(c.getBackground());
                graphics.drawLine(xOffset, 2, s.width, 2);
                graphics.drawLine(xOffset, 0, xOffset, 0);
                graphics.drawLine(xOffset, 3, xOffset, 3);
            } else {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceCoreUtilities.getActiveScheme(sep);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                    GradientPaint gp = new GradientPaint(s.width - xOffset, 0.0f, leftColor, s.width, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite((Component)sep, 0.7f));
                    graphics.setPaint(gp);
                    graphics.fillRect(s.width - xOffset - 2, 0, s.width, c.getHeight());
                }
                graphics.setComposite(TransitionLayout.getAlphaComposite(sep));
                graphics.setColor(c.getForeground());
                graphics.drawLine(0, 1, s.width - xOffset - 4, 1);
                graphics.setColor(c.getBackground());
                graphics.drawLine(0, 2, s.width - xOffset - 4, 2);
                graphics.drawLine(0, 0, 0, 0);
                graphics.drawLine(0, 3, 0, 3);
            }
        }
        finally {
            graphics.dispose();
        }
    }
}

