/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.rmi;

import com.lightcrafts.media.jai.rmi.InterfaceHandler;
import com.lightcrafts.media.jai.rmi.JaiI18N;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.remote.SerializableState;
import com.lightcrafts.mediax.jai.remote.Serializer;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class InterfaceState
implements SerializableState {
    private transient Object theObject;
    private transient Serializer[] theSerializers;
    private transient RenderingHints hints;

    public InterfaceState(Object o, Serializer[] serializers, RenderingHints h) {
        if (o == null || serializers == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.theObject = o;
        this.theSerializers = serializers;
        this.hints = h == null ? null : (RenderingHints)h.clone();
    }

    @Override
    public Object getObject() {
        return this.theObject;
    }

    @Override
    public Class getObjectClass() {
        return this.theObject.getClass();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int numSerializers = this.theSerializers.length;
        out.writeInt(numSerializers);
        for (int i = 0; i < numSerializers; ++i) {
            Serializer s = this.theSerializers[i];
            out.writeObject(s.getSupportedClass());
            out.writeObject(s.getState(this.theObject, this.hints));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int numInterfaces = in.readInt();
        Class[] interfaces = new Class[numInterfaces];
        SerializableState[] implementations = new SerializableState[numInterfaces];
        for (int i = 0; i < numInterfaces; ++i) {
            interfaces[i] = (Class)in.readObject();
            implementations[i] = (SerializableState)in.readObject();
        }
        InterfaceHandler handler = new InterfaceHandler(interfaces, implementations);
        this.theObject = Proxy.newProxyInstance(JAI.class.getClassLoader(), interfaces, (InvocationHandler)handler);
    }
}

