/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.rmi;

import com.lightcrafts.media.jai.rmi.JaiI18N;
import com.lightcrafts.media.jai.rmi.SerializableStateImpl;
import com.lightcrafts.media.jai.util.DataBufferUtils;
import com.lightcrafts.mediax.jai.DataBufferDouble;
import com.lightcrafts.mediax.jai.DataBufferFloat;
import java.awt.RenderingHints;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DataBufferState
extends SerializableStateImpl {
    private static Class[] J2DDataBufferClasses = null;
    private transient DataBuffer dataBuffer;

    public static Class[] getSupportedClasses() {
        Class[] supportedClasses = null;
        supportedClasses = J2DDataBufferClasses != null ? new Class[]{DataBufferByte.class, DataBufferShort.class, DataBufferUShort.class, DataBufferInt.class, J2DDataBufferClasses[0], J2DDataBufferClasses[1], DataBufferFloat.class, DataBufferDouble.class, com.lightcrafts.media.jai.codecimpl.util.DataBufferFloat.class, com.lightcrafts.media.jai.codecimpl.util.DataBufferDouble.class} : new Class[]{DataBufferByte.class, DataBufferShort.class, DataBufferUShort.class, DataBufferInt.class, DataBufferFloat.class, DataBufferDouble.class, com.lightcrafts.media.jai.codecimpl.util.DataBufferFloat.class, com.lightcrafts.media.jai.codecimpl.util.DataBufferDouble.class};
        return supportedClasses;
    }

    public DataBufferState(Class c, Object o, RenderingHints h) {
        super(c, o, h);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        DataBuffer dataBuffer = (DataBuffer)this.theObject;
        int dataType = dataBuffer.getDataType();
        out.writeInt(dataType);
        out.writeObject(dataBuffer.getOffsets());
        out.writeInt(dataBuffer.getSize());
        Object dataArray = null;
        switch (dataType) {
            case 0: {
                dataArray = ((DataBufferByte)dataBuffer).getBankData();
                break;
            }
            case 2: {
                dataArray = ((DataBufferShort)dataBuffer).getBankData();
                break;
            }
            case 1: {
                dataArray = ((DataBufferUShort)dataBuffer).getBankData();
                break;
            }
            case 3: {
                dataArray = ((DataBufferInt)dataBuffer).getBankData();
                break;
            }
            case 4: {
                dataArray = DataBufferUtils.getBankDataFloat(dataBuffer);
                break;
            }
            case 5: {
                dataArray = DataBufferUtils.getBankDataDouble(dataBuffer);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferState0"));
            }
        }
        out.writeObject(dataArray);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DataBuffer dataBuffer = null;
        int dataType = -1;
        int[] offsets = null;
        int size = -1;
        Object dataArray = null;
        dataType = in.readInt();
        offsets = (int[])in.readObject();
        size = in.readInt();
        dataArray = in.readObject();
        switch (dataType) {
            case 0: {
                dataBuffer = new DataBufferByte((byte[][])dataArray, size, offsets);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort((short[][])dataArray, size, offsets);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort((short[][])dataArray, size, offsets);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt((int[][])dataArray, size, offsets);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat((float[][])dataArray, size, offsets);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble((double[][])dataArray, size, offsets);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferState0"));
            }
        }
        this.theObject = dataBuffer;
    }

    static {
        try {
            Class<?> dbfClass = Class.forName("java.awt.image.DataBufferFloat");
            Class<?> dbdClass = Class.forName("java.awt.image.DataBufferDouble");
            J2DDataBufferClasses = new Class[]{dbfClass, dbdClass};
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

