/*
 * Decompiled with CFR 0.152.
 */
package tilecachetool;

import com.lightcrafts.jai.utils.LCTileCache;
import com.lightcrafts.mediax.jai.CachedTile;
import com.lightcrafts.mediax.jai.EnumeratedParameter;
import com.lightcrafts.mediax.jai.JAI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import tilecachetool.EventViewer;
import tilecachetool.MemoryChart;
import tilecachetool.Statistics;
import tilecachetool.TCInfo;

public final class TCTool
extends JFrame
implements ActionListener,
Observer {
    private LCTileCache cache = null;
    private JPanel top_panel;
    private JButton gc_btn;
    private JButton flush_btn;
    private JButton reset_btn;
    private JButton quit_btn;
    private JMenu options_menu;
    private JMenuItem pack_item;
    private JMenu capacity_menu;
    private JMenu delay_menu;
    private JMenu rows_menu;
    private JMenu laf_menu;
    private JRadioButton rad1;
    private JRadioButton rad2;
    private JRadioButton rad3;
    private JRadioButton rad4;
    private static final String METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private String current_laf = "javax.swing.plaf.metal.MetalLookAndFeel";
    private final MemoryChart memoryChart = new MemoryChart();
    private final EventViewer eventViewer = new EventViewer();
    private final Statistics statistics = new Statistics();
    private final TCInfo information = new TCInfo();
    private static final Color LIGHT_BLUE = new Color(200, 200, 220);
    private static final LineBorder LINE_BORDER = new LineBorder(Color.darkGray, 1);
    private static final String[] capacities = new String[]{"32MB", "64MB", "128MB", "256MB", "512MB"};
    private static final String[] delays = new String[]{"10ms", "50ms", "100ms", "250ms", "500ms", "1000ms", "2000ms", "5000ms"};
    private static final String[] rows = new String[]{"1", "4", "7", "10", "15", "20"};
    private long tileSize = 0L;
    private long timeStamp = 0L;
    private long addTile = 0L;
    private long removeTile = 0L;
    private long removeFlushed = 0L;
    private long removeMemoryControl = 0L;
    private long updateAddTile = 0L;
    private long updateGetTile = 0L;
    private long removeGC = 0L;
    private EnumeratedParameter[] actions;
    private int CACHE_EVENT_ADD;
    private int CACHE_EVENT_REMOVE;
    private int CACHE_EVENT_REMOVE_BY_FLUSH;
    private int CACHE_EVENT_REMOVE_BY_MEMORY_CONTROL;
    private int CACHE_EVENT_UPDATE_FROM_ADD;
    private int CACHE_EVENT_UPDATE_FROM_GETTILE;
    private int CACHE_EVENT_ABOUT_TO_REMOVE_TILE;
    private int CACHE_EVENT_REMOVE_BY_GC;
    private static final String about_msg = "<html><center>Tile Cache Tool</center<p><center>Version 1.01</center></p><center>October 25, 2002</center><p><center>Copyright (c) 2002, Virtual Visions Software, Inc.</center></p><center>All Rights Reserved</center><br></br></html>";

    public TCTool() {
        this.create(-1L, null);
    }

    public TCTool(long memoryCapacity) {
        this.create(memoryCapacity, null);
    }

    public TCTool(LCTileCache lcTileCache) {
        this.create(-1L, lcTileCache);
    }

    private JMenuItem createAboutBox() {
        JMenuItem about = new JMenuItem("About...");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(TCTool.this.top_panel, TCTool.about_msg);
            }
        });
        return about;
    }

    private void create(long memoryCapacity, LCTileCache lcTileCache) {
        JMenuItem item;
        int i;
        this.setTitle("Tile Cache Tool");
        this.setDefaultCloseOperation(2);
        this.setBackground(LIGHT_BLUE);
        this.top_panel = new JPanel();
        this.top_panel.setLayout(new BorderLayout());
        this.getContentPane().add(this.top_panel);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setLayout(new FlowLayout(0, 15, 5));
        menuBar.setBackground(LIGHT_BLUE);
        this.options_menu = new JMenu("Options");
        this.pack_item = new JMenuItem("Refit Window");
        this.pack_item.addActionListener(this);
        this.pack_item.setToolTipText("Restore this window to original size.");
        this.capacity_menu = new JMenu("Max Memory");
        for (i = 0; i < capacities.length; ++i) {
            item = new JMenuItem(capacities[i]);
            item.addActionListener(this);
            this.capacity_menu.add(item);
        }
        this.delay_menu = new JMenu("Time Delay");
        for (i = 0; i < delays.length; ++i) {
            item = new JMenuItem(delays[i]);
            item.addActionListener(this);
            this.delay_menu.add(item);
        }
        this.rows_menu = new JMenu("Event Rows");
        this.rows_menu.addActionListener(this);
        for (i = 0; i < rows.length; ++i) {
            item = new JMenuItem(rows[i]);
            item.addActionListener(this);
            this.rows_menu.add(item);
        }
        this.laf_menu = new JMenu("Look & Feel");
        JMenuItem tmp_item = new JMenuItem("Metal");
        tmp_item.addActionListener(this);
        this.laf_menu.add(tmp_item);
        tmp_item = new JMenuItem("Windows");
        tmp_item.addActionListener(this);
        this.laf_menu.add(tmp_item);
        tmp_item = new JMenuItem("Motif");
        tmp_item.addActionListener(this);
        this.laf_menu.add(tmp_item);
        tmp_item = new JMenuItem("Mac");
        tmp_item.addActionListener(this);
        this.laf_menu.add(tmp_item);
        this.options_menu.add(this.pack_item);
        this.options_menu.add(this.capacity_menu);
        this.options_menu.add(this.delay_menu);
        this.options_menu.add(this.rows_menu);
        this.options_menu.add(this.laf_menu);
        this.options_menu.add(this.createAboutBox());
        menuBar.add(this.options_menu);
        this.top_panel.add((Component)menuBar, "North");
        JPanel t2 = new JPanel();
        t2.setLayout(new FlowLayout(0, 5, 0));
        t2.setBorder(LINE_BORDER);
        JLabel label1 = new JLabel("Diagnostics:  ");
        t2.add(label1);
        this.rad1 = new JRadioButton("On", true);
        this.rad2 = new JRadioButton("Off");
        this.rad1.addActionListener(this);
        this.rad2.addActionListener(this);
        t2.add(this.rad1);
        t2.add(this.rad2);
        this.rad1.setToolTipText("Perform diagnostics monitoring");
        this.rad2.setToolTipText("Stop diagnostics monitoring");
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.rad1);
        bg1.add(this.rad2);
        menuBar.add(t2);
        JPanel t3 = new JPanel();
        t3.setLayout(new FlowLayout(0, 5, 0));
        t3.setBorder(LINE_BORDER);
        JLabel label2 = new JLabel("Cache:  ");
        t3.add(label2);
        this.rad3 = new JRadioButton("Enabled", true);
        this.rad4 = new JRadioButton("Disabled");
        this.rad3.addActionListener(this);
        this.rad4.addActionListener(this);
        t3.add(this.rad3);
        t3.add(this.rad4);
        this.rad3.setToolTipText("Resume normal cache operations");
        this.rad4.setToolTipText("Block new cache operations (status quo)");
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.rad3);
        bg2.add(this.rad4);
        menuBar.add(t3);
        JPanel center_panel = new JPanel();
        center_panel.setLayout(new BorderLayout());
        center_panel.setBackground(LIGHT_BLUE);
        this.top_panel.add((Component)center_panel, "Center");
        this.cache = lcTileCache == null ? (LCTileCache)JAI.getDefaultInstance().getTileCache() : lcTileCache;
        TCTool tCTool = this;
        this.actions = tCTool.cache.getCachedTileActions();
        this.CACHE_EVENT_ADD = this.actions[0].getValue();
        this.CACHE_EVENT_REMOVE = this.actions[1].getValue();
        this.CACHE_EVENT_REMOVE_BY_FLUSH = this.actions[2].getValue();
        this.CACHE_EVENT_REMOVE_BY_MEMORY_CONTROL = this.actions[3].getValue();
        this.CACHE_EVENT_UPDATE_FROM_ADD = this.actions[4].getValue();
        this.CACHE_EVENT_UPDATE_FROM_GETTILE = this.actions[5].getValue();
        this.CACHE_EVENT_ABOUT_TO_REMOVE_TILE = this.actions[6].getValue();
        this.CACHE_EVENT_REMOVE_BY_GC = this.actions[7].getValue();
        if (memoryCapacity >= 0L) {
            this.cache.setMemoryCapacity(memoryCapacity);
        }
        this.cache.enableDiagnostics();
        this.cache.addObserver(this);
        JPanel stat_panel = new JPanel();
        stat_panel.setBackground(LIGHT_BLUE);
        stat_panel.setBorder(new EtchedBorder(1));
        stat_panel.setLayout(new FlowLayout(1, 10, 2));
        this.gc_btn = new JButton("Force GC");
        this.flush_btn = new JButton("Flush Cache");
        this.reset_btn = new JButton("Reset");
        this.quit_btn = new JButton("Quit");
        this.gc_btn.addActionListener(this);
        this.flush_btn.addActionListener(this);
        this.reset_btn.addActionListener(this);
        this.quit_btn.addActionListener(this);
        this.gc_btn.setToolTipText("Force a call to System.gc()");
        this.flush_btn.setToolTipText("Empty the tile cache.");
        this.reset_btn.setToolTipText("Clear counters and reset.");
        this.quit_btn.setToolTipText("Close the Tile Cache Tool window.");
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(4, 1, 5, 15));
        p1.setBackground(LIGHT_BLUE);
        p1.add(this.gc_btn);
        p1.add(this.flush_btn);
        p1.add(this.reset_btn);
        p1.add(this.quit_btn);
        stat_panel.add(p1);
        this.information.setTileCache(this.cache);
        this.information.setBackground(LIGHT_BLUE);
        this.information.setStatistics(this.statistics);
        stat_panel.add(this.information);
        center_panel.add((Component)stat_panel, "North");
        this.statistics.setBackground(LIGHT_BLUE);
        stat_panel.add(this.statistics);
        center_panel.add((Component)this.memoryChart, "Center");
        this.memoryChart.start();
        JPanel p0 = new JPanel();
        p0.setBackground(LIGHT_BLUE);
        p0.setLayout(new FlowLayout(1, 5, 5));
        p0.add(this.eventViewer);
        center_panel.add((Component)p0, "South");
        final TCTool tctool = this;
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TCTool.this.memoryChart.stop();
                TCTool.this.cache.deleteObserver(tctool);
                TCTool.this.cache.disableDiagnostics();
                TCTool.this.cache = null;
                System.gc();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                TCTool.this.memoryChart.stop();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                TCTool.this.memoryChart.start();
            }
        };
        this.addWindowListener(wl);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton rb;
        Object tmp = e.getSource();
        if (tmp instanceof JRadioButton && (rb = (JRadioButton)tmp).isSelected()) {
            if (rb == this.rad1) {
                if (this.cache != null) {
                    this.cache.enableDiagnostics();
                    this.memoryChart.start();
                }
            } else if (rb == this.rad2) {
                if (this.cache != null) {
                    this.cache.disableDiagnostics();
                    this.memoryChart.stop();
                }
            } else if (rb == this.rad3) {
                JAI.enableDefaultTileCache();
            } else if (rb == this.rad4) {
                JAI.disableDefaultTileCache();
            }
        }
        if (tmp instanceof JButton) {
            JButton button = (JButton)tmp;
            if (button == this.gc_btn) {
                System.gc();
            } else if (button == this.flush_btn) {
                if (this.cache != null) {
                    this.cache.flush();
                }
            } else if (button == this.reset_btn) {
                if (this.cache != null) {
                    this.cache.flush();
                }
                this.addTile = 0L;
                this.removeTile = 0L;
                this.removeFlushed = 0L;
                this.removeMemoryControl = 0L;
                this.updateAddTile = 0L;
                this.updateGetTile = 0L;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TCTool.this.statistics.clear();
                        TCTool.this.eventViewer.clear();
                    }
                });
                System.gc();
            } else if (button == this.quit_btn) {
                this.memoryChart.stop();
                this.cache.deleteObserver(this);
                this.cache.disableDiagnostics();
                this.cache = null;
                this.dispose();
                System.gc();
            }
        }
        if (tmp instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)tmp;
            if (item == this.pack_item) {
                this.pack();
            } else {
                int i;
                String cmd = item.getText();
                if (cmd.equalsIgnoreCase("Metal")) {
                    this.setLookAndFeel(METAL);
                    return;
                }
                if (cmd.equalsIgnoreCase("Windows")) {
                    this.setLookAndFeel(WINDOWS);
                    return;
                }
                if (cmd.equalsIgnoreCase("Motif")) {
                    this.setLookAndFeel(MOTIF);
                    return;
                }
                if (cmd.equalsIgnoreCase("Mac")) {
                    this.setLookAndFeel(MAC);
                    return;
                }
                for (i = 0; i < capacities.length; ++i) {
                    if (!cmd.equals(capacities[i])) continue;
                    String str = capacities[i].substring(0, capacities[i].lastIndexOf("M"));
                    int mem_max = Integer.parseInt(str);
                    this.information.setMemoryCapacitySliderMaximum(mem_max);
                    return;
                }
                for (i = 0; i < delays.length; ++i) {
                    if (!cmd.equals(delays[i])) continue;
                    String str = delays[i].substring(0, delays[i].lastIndexOf("m"));
                    this.memoryChart.setDelay(Integer.parseInt(str));
                    return;
                }
                for (i = 0; i < rows.length; ++i) {
                    if (!cmd.equals(rows[i])) continue;
                    this.eventViewer.setRows(Integer.parseInt(rows[i]));
                    this.pack();
                    return;
                }
            }
        }
    }

    private void setLookAndFeel(String laf) {
        if (this.current_laf != laf) {
            this.current_laf = laf;
            try {
                UIManager.setLookAndFeel(this.current_laf);
                SwingUtilities.updateComponentTreeUI(this);
                this.pack();
            }
            catch (Exception e) {
                System.out.println("Look and Feel not supported.");
                this.current_laf = METAL;
            }
        }
    }

    @Override
    public synchronized void update(Observable possibleSunTileCache, Object possibleCachedTile) {
        String jai_op;
        LCTileCache lc_tile_cache = null;
        CachedTile cached_tile = null;
        int cache_event = -1;
        if (!(possibleSunTileCache instanceof LCTileCache)) {
            return;
        }
        lc_tile_cache = (LCTileCache)possibleSunTileCache;
        if (possibleCachedTile != null && possibleCachedTile instanceof CachedTile) {
            cached_tile = (CachedTile)possibleCachedTile;
            cache_event = cached_tile.getAction();
            if (cache_event == this.CACHE_EVENT_ABOUT_TO_REMOVE_TILE) {
                return;
            }
        } else {
            return;
        }
        RenderedImage image = cached_tile.getOwner();
        long tileSize = cached_tile.getTileSize();
        long timeStamp = cached_tile.getTileTimeStamp();
        final long cacheHits = lc_tile_cache.getCacheHitCount();
        final long cacheMisses = lc_tile_cache.getCacheMissCount();
        final long tileCount = lc_tile_cache.getCacheTileCount();
        float memoryCapacity = lc_tile_cache.getMemoryCapacity();
        float memoryUsage = lc_tile_cache.getCacheMemoryUsed();
        final int percentTCM = (int)(100.0f * memoryUsage / memoryCapacity + 0.5f);
        if (image != null) {
            String temp = image.getClass().getName();
            jai_op = temp.substring(temp.lastIndexOf(".") + 1);
        } else {
            jai_op = "Op was removed by GC";
        }
        final Vector<String> eventData = new Vector<String>(5, 1);
        eventData.addElement(jai_op);
        if (cache_event == this.CACHE_EVENT_ADD) {
            eventData.addElement("Add");
            ++this.addTile;
        } else if (cache_event == this.CACHE_EVENT_REMOVE) {
            eventData.addElement("Remove");
            ++this.removeTile;
        } else if (cache_event == this.CACHE_EVENT_REMOVE_BY_FLUSH) {
            eventData.addElement("Remove by Flush");
            ++this.removeFlushed;
        } else if (cache_event == this.CACHE_EVENT_REMOVE_BY_MEMORY_CONTROL) {
            eventData.addElement("Remove by Memory Control");
            ++this.removeMemoryControl;
        } else if (cache_event == this.CACHE_EVENT_UPDATE_FROM_ADD) {
            eventData.addElement("Update from Add");
            ++this.updateAddTile;
        } else if (cache_event == this.CACHE_EVENT_UPDATE_FROM_GETTILE) {
            eventData.addElement("Update from GetTile");
            ++this.updateGetTile;
        } else if (cache_event == this.CACHE_EVENT_REMOVE_BY_GC) {
            eventData.addElement("Remove by Memory Control");
            ++this.removeGC;
        }
        eventData.addElement("" + tileSize);
        eventData.addElement("" + timeStamp);
        final long f_addTile = this.addTile;
        final long f_removeTile = this.removeTile;
        final long f_removeFlushed = this.removeFlushed;
        final long f_removeMemoryControl = this.removeMemoryControl;
        final long f_removeGC = this.removeGC;
        final long f_updateAddTile = this.updateAddTile;
        final long f_updateGetTile = this.updateGetTile;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TCTool.this.eventViewer.insertRow(0, eventData);
                TCTool.this.statistics.set(tileCount, cacheHits, cacheMisses, f_addTile, f_removeTile, f_removeFlushed, f_removeMemoryControl, f_removeGC, f_updateAddTile, f_updateGetTile, percentTCM);
            }
        });
    }
}

