/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.directory;

import com.lightcrafts.utils.directory.DirectoryListener;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public final class UnixDirectoryMonitor
extends DirectoryMonitor {
    private final Map<File, Long> m_dirMap = new HashMap<File, Long>();

    public UnixDirectoryMonitor() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectory(File directory) {
        Long value = directory.lastModified();
        Map<File, Long> map = this.m_dirMap;
        synchronized (map) {
            boolean added = this.m_dirMap.put(directory, value) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDirectory(File directory) {
        boolean removed;
        Map<File, Long> map = this.m_dirMap;
        synchronized (map) {
            removed = this.m_dirMap.remove(directory) != null;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File[] getMonitoredDirectories() {
        Map<File, Long> map = this.m_dirMap;
        synchronized (map) {
            return this.m_dirMap.keySet().toArray(new File[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasChanged(File dir) {
        if (dir.exists()) {
            Map<File, Long> map = this.m_dirMap;
            synchronized (map) {
                long newValue;
                Long prevValue = this.m_dirMap.get(dir);
                if (prevValue != null && (newValue = dir.lastModified()) != prevValue) {
                    this.m_dirMap.put(dir, newValue);
                    return true;
                }
            }
        } else {
            return this.removeDirectory(dir);
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        UnixDirectoryMonitor monitor = new UnixDirectoryMonitor();
        TestListener listener = new TestListener();
        monitor.addListener(listener);
        BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String dir;
            System.out.print("> ");
            String cmd = commandLine.readLine();
            if (cmd.length() == 0) continue;
            if (cmd.startsWith("+ ")) {
                dir = cmd.substring(2);
                ((DirectoryMonitor)monitor).addDirectory(new File(dir));
                continue;
            }
            if (cmd.startsWith("- ")) {
                dir = cmd.substring(2);
                ((DirectoryMonitor)monitor).removeDirectory(new File(dir));
                continue;
            }
            System.err.println("Unknown command");
        }
    }

    private static final class TestListener
    implements DirectoryListener {
        private TestListener() {
        }

        @Override
        public void directoryChanged(File dir) {
            System.out.println(dir.getAbsolutePath());
        }
    }
}

