/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.directory;

import com.lightcrafts.utils.directory.DirectoryListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public abstract class DirectoryMonitor {
    static final boolean DEBUG = false;
    private final Collection<DirectoryListener> m_listeners = new ArrayList<DirectoryListener>();
    private final MonitorThread m_monitorThread = new MonitorThread();
    private int m_suspendCount;

    public abstract void addDirectory(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(DirectoryListener listener) {
        Collection<DirectoryListener> collection = this.m_listeners;
        synchronized (collection) {
            this.m_listeners.add(listener);
        }
    }

    public void dispose() {
        this.m_monitorThread.stopMonitoring();
    }

    public final synchronized void resume(boolean force) {
        if (force || --this.m_suspendCount < 0) {
            this.m_suspendCount = 0;
        }
    }

    public abstract boolean removeDirectory(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeListener(DirectoryListener listener) {
        Collection<DirectoryListener> collection = this.m_listeners;
        synchronized (collection) {
            return this.m_listeners.remove(listener);
        }
    }

    public final synchronized void suspend() {
        ++this.m_suspendCount;
    }

    static void doze(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected abstract File[] getMonitoredDirectories();

    protected abstract boolean hasChanged(File var1);

    protected void start() {
        this.m_monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAbout(File dir) {
        Collection<DirectoryListener> collection = this.m_listeners;
        synchronized (collection) {
            for (DirectoryListener listener : this.m_listeners) {
                listener.directoryChanged(dir);
            }
        }
    }

    private final class MonitorThread
    extends Thread {
        private boolean m_stop;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.m_stop) {
                int suspendCount;
                DirectoryMonitor directoryMonitor = DirectoryMonitor.this;
                synchronized (directoryMonitor) {
                    suspendCount = DirectoryMonitor.this.m_suspendCount;
                }
                if (suspendCount == 0) {
                    for (File dir : DirectoryMonitor.this.getMonitoredDirectories()) {
                        if (!DirectoryMonitor.this.hasChanged(dir)) continue;
                        DirectoryMonitor.this.notifyListenersAbout(dir);
                    }
                }
                DirectoryMonitor.doze(3000L);
            }
        }

        void stopMonitoring() {
            this.m_stop = true;
        }

        private MonitorThread() {
            super("DirectoryMonitor.MonitorThread");
            this.setDaemon(true);
            this.setPriority(1);
        }
    }
}

