/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

public final class Rational
extends Number
implements Comparable {
    private final int m_numerator;
    private final int m_denominator;

    public Rational(int numerator, int denominator) {
        if (denominator == 0) {
            throw new IllegalArgumentException();
        }
        int d = Rational.gcd(Math.abs(numerator), Math.abs(denominator));
        this.m_numerator = numerator / d;
        this.m_denominator = denominator / d;
    }

    @Override
    public byte byteValue() {
        return (byte)this.doubleValue();
    }

    public int compareTo(Object o) {
        double cmp = this.doubleValue() - ((Number)o).doubleValue();
        return cmp < 0.0 ? -1 : (cmp > 0.0 ? 1 : 0);
    }

    public int denominator() {
        return this.m_denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.m_numerator / (double)this.m_denominator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Rational r = (Rational)o;
        return this.doubleValue() == r.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.m_numerator / (float)this.m_denominator;
    }

    @Override
    public int intValue() {
        return this.m_numerator / this.m_denominator;
    }

    public boolean isInteger() {
        return this.m_numerator % this.m_denominator == 0;
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public int numerator() {
        return this.m_numerator;
    }

    public static Rational parseRational(String s) {
        String[] parts = s.split("/");
        if (parts.length == 2) {
            return new Rational(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        return new Rational(Integer.parseInt(s), 1);
    }

    public Rational reciprocal() {
        return new Rational(this.m_denominator, this.m_numerator);
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    public String toString() {
        return this.m_numerator + "/" + this.m_denominator;
    }

    private static int gcd(int n, int m) {
        int factor = 1;
        while ((n & 1) == 0 && (m & 1) == 0) {
            n >>>= 1;
            m >>>= 1;
            factor <<= 1;
        }
        while (n > 0) {
            if ((n & 1) == 0) {
                n >>>= 1;
                continue;
            }
            if ((m & 1) == 0) {
                m >>>= 1;
                continue;
            }
            if (n < m) {
                m = m - n >>> 1;
                continue;
            }
            n = n - m >>> 1;
        }
        return factor * m;
    }
}

