/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.platform.Platform;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;

public final class LocaleUtil {
    private final ResourceBundle m_resources;

    public LocaleUtil(Class localeClass) {
        this.m_resources = ResourceBundle.getBundle(localeClass.getName());
    }

    public String get(String key) {
        try {
            return this.m_resources.getString(key);
        }
        catch (MissingResourceException e) {
            return this.m_resources.getString(key + (Object)((Object)Platform.getType()));
        }
    }

    public String get(String key, int ... subs) {
        String[] subsAsStrings = new String[subs.length];
        for (int i = 0; i < subs.length; ++i) {
            subsAsStrings[i] = Integer.toString(subs[i]);
        }
        return this.get(key, subsAsStrings);
    }

    public String get(String key, String ... subs) {
        String s = this.get(key);
        for (int i = 0; i < subs.length; ++i) {
            s = s.replaceFirst("\\$" + (i + 1), Matcher.quoteReplacement(subs[i]));
        }
        return s;
    }
}

