/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

public class HSB {
    public static void fromRGB(float[] rgb, float[] hsb) {
        float hue;
        float cmin;
        float cmax;
        if (hsb == null) {
            hsb = new float[3];
        }
        float f = cmax = rgb[0] > rgb[1] ? rgb[0] : rgb[1];
        if (rgb[2] > cmax) {
            cmax = rgb[2];
        }
        float f2 = cmin = rgb[0] < rgb[1] ? rgb[0] : rgb[1];
        if (rgb[2] < cmin) {
            cmin = rgb[2];
        }
        float brightness = cmax;
        float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - rgb[0]) / (cmax - cmin);
            float greenc = (cmax - rgb[1]) / (cmax - cmin);
            float bluec = (cmax - rgb[2]) / (cmax - cmin);
            hue = rgb[0] == cmax ? bluec - greenc : (rgb[1] == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsb[0] = hue;
        hsb[1] = saturation;
        hsb[2] = brightness;
    }

    public static float hue(float r, float g, float b) {
        float hue;
        float cmin;
        float cmax;
        float f = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        float f2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        if (cmax - cmin == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return hue;
    }

    public static void toRGBSlow(float[] hsb, float[] rgb) {
        if (hsb[1] == 0.0f) {
            rgb[1] = rgb[2] = hsb[2];
            rgb[0] = rgb[2];
        } else {
            rgb[2] = 0.0f;
            rgb[1] = 0.0f;
            rgb[0] = 0.0f;
            float h = (hsb[0] - (float)Math.floor(hsb[0])) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = hsb[2] * (1.0f - hsb[1]);
            float q = hsb[2] * (1.0f - hsb[1] * f);
            float t = hsb[2] * (1.0f - hsb[1] * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    rgb[0] = hsb[2];
                    rgb[1] = t;
                    rgb[2] = p;
                    break;
                }
                case 1: {
                    rgb[0] = q;
                    rgb[1] = hsb[2];
                    rgb[2] = p;
                    break;
                }
                case 2: {
                    rgb[0] = p;
                    rgb[1] = hsb[2];
                    rgb[2] = t;
                    break;
                }
                case 3: {
                    rgb[0] = p;
                    rgb[1] = q;
                    rgb[2] = hsb[2];
                    break;
                }
                case 4: {
                    rgb[0] = t;
                    rgb[1] = p;
                    rgb[2] = hsb[2];
                    break;
                }
                case 5: {
                    rgb[0] = hsb[2];
                    rgb[1] = p;
                    rgb[2] = q;
                }
            }
        }
    }

    public static void toRGB(float[] hsb, float[] rgb) {
        if (hsb[2] == 0.0f) {
            rgb[2] = 0.0f;
            rgb[1] = 0.0f;
            rgb[0] = 0.0f;
            return;
        }
        if (hsb[1] == 0.0f) {
            rgb[1] = rgb[2] = hsb[2];
            rgb[0] = rgb[2];
            return;
        }
        if ((double)hsb[0] < 0.16666666666666666) {
            float domainOffset = hsb[0];
            rgb[0] = hsb[2];
            rgb[2] = hsb[2] * (1.0f - hsb[1]);
            rgb[1] = rgb[2] + (hsb[2] - rgb[2]) * domainOffset * 6.0f;
        } else if ((double)hsb[0] < 0.3333333333333333) {
            float domainOffset = hsb[0] - 0.16666667f;
            rgb[1] = hsb[2];
            rgb[2] = hsb[2] * (1.0f - hsb[1]);
            rgb[0] = rgb[1] - (hsb[2] - rgb[2]) * domainOffset * 6.0f;
        } else if ((double)hsb[0] < 0.5) {
            float domainOffset = hsb[0] - 0.33333334f;
            rgb[1] = hsb[2];
            rgb[0] = hsb[2] * (1.0f - hsb[1]);
            rgb[2] = rgb[0] + (hsb[2] - rgb[0]) * domainOffset * 6.0f;
        } else if ((double)hsb[0] < 0.6666666666666666) {
            float domainOffset = hsb[0] - 0.5f;
            rgb[2] = hsb[2];
            rgb[0] = hsb[2] * (1.0f - hsb[1]);
            rgb[1] = rgb[2] - (hsb[2] - rgb[0]) * domainOffset * 6.0f;
        } else if ((double)hsb[0] < 0.8333333333333334) {
            float domainOffset = hsb[0] - 0.6666667f;
            rgb[2] = hsb[2];
            rgb[1] = hsb[2] * (1.0f - hsb[1]);
            rgb[0] = rgb[1] + (hsb[2] - rgb[1]) * domainOffset * 6.0f;
        } else {
            float domainOffset = hsb[0] - 0.8333333f;
            rgb[0] = hsb[2];
            rgb[1] = hsb[2] * (1.0f - hsb[1]);
            rgb[2] = rgb[0] - (hsb[2] - rgb[1]) * domainOffset * 6.0f;
        }
    }
}

