/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.utils.SoftValueHashMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;

public class DropShadow {
    protected Dimension dimension;
    protected float angle = 30.0f;
    protected int distance = 5;
    protected int shadowSize = 5;
    protected float shadowOpacity = 0.5f;
    protected Color shadowColor = new Color(0);
    protected Color backgroundColor = Color.white;
    protected int distance_x = 0;
    protected int distance_y = 0;
    private static Map shadowMap = new SoftValueHashMap();

    public boolean equals(Object obj) {
        if (obj instanceof DropShadow) {
            DropShadow ds = (DropShadow)obj;
            return this.dimension.equals(ds.dimension) && this.angle == ds.angle && this.distance == ds.distance && this.shadowSize == ds.shadowSize && this.shadowColor.equals(ds.shadowColor) && this.backgroundColor.equals(ds.backgroundColor);
        }
        return false;
    }

    public int hashCode() {
        return (int)((float)(this.dimension.hashCode() + this.shadowColor.hashCode() + this.backgroundColor.hashCode()) + this.angle + (float)this.distance + (float)this.shadowSize + this.shadowOpacity);
    }

    public DropShadow(Dimension d) {
        this.computeShadowPosition();
        this.dimension = d != null ? d : null;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.computeShadowPosition();
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
        this.computeShadowPosition();
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setShadowColor(Color shadowColor) {
        if (shadowColor != null) {
            this.shadowColor = shadowColor;
        }
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
    }

    private void computeShadowPosition() {
        double angleRadians = Math.toRadians(this.angle);
        this.distance_x = (int)(Math.cos(angleRadians) * (double)this.distance);
        this.distance_y = (int)(Math.sin(angleRadians) * (double)this.distance);
    }

    private synchronized BufferedImage createDropShadow() {
        BufferedImage shadow = (BufferedImage)shadowMap.get(this);
        if (shadow == null && (shadow = (BufferedImage)shadowMap.get(this)) == null) {
            BufferedImage shadowMask = this.shadowOpacity == 1.0f ? this.createShadowMask(this.dimension) : this.createTranslucentShadowMask(this.dimension);
            shadow = this.getGaussianBlur(this.shadowSize, shadowMask);
            shadowMap.put(this, shadow);
        }
        return shadow;
    }

    private BufferedImage createTranslucentShadowMask(Dimension d) {
        BufferedImage mask = new BufferedImage(d.width + this.shadowSize * 2, d.height + this.shadowSize * 2, 2);
        Graphics2D g2d = mask.createGraphics();
        g2d.fillRect(this.shadowSize, this.shadowSize, d.width, d.height);
        g2d.setComposite(AlphaComposite.getInstance(5, this.shadowOpacity));
        g2d.setColor(this.shadowColor);
        g2d.fillRect(0, 0, d.width + this.shadowSize * 2, d.height + this.shadowSize * 2);
        g2d.dispose();
        return mask;
    }

    private BufferedImage createShadowMask(Dimension d) {
        BufferedImage mask = new BufferedImage(d.width + this.shadowSize * 2, d.height + this.shadowSize * 2, 1);
        Graphics2D g2d = mask.createGraphics();
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, d.width + this.shadowSize * 2, d.height + this.shadowSize * 2);
        g2d.setColor(this.shadowColor);
        g2d.fillRect(this.shadowSize, this.shadowSize, d.width, d.height);
        g2d.dispose();
        return mask;
    }

    private BufferedImage getGaussianBlur(int size, BufferedImage image) {
        KernelJAI kernel = Functions.getGaussKernel((double)size / 3.0);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(kernel);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        hints.add(JAIContext.noCacheHint);
        return JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, (RenderingHints)hints).getAsBufferedImage();
    }

    public BufferedImage getShadow() {
        return this.createDropShadow();
    }

    public AffineTransform getShadowTransform(int x, int y) {
        return AffineTransform.getTranslateInstance(x - this.shadowSize + this.distance_x, y - this.shadowSize + this.distance_y);
    }
}

