/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.CoolButtonBackground;
import com.lightcrafts.ui.toolkit.CoolButtonCenterBackground;
import com.lightcrafts.ui.toolkit.CoolButtonLeftBackground;
import com.lightcrafts.ui.toolkit.CoolButtonNormalBackground;
import com.lightcrafts.ui.toolkit.CoolButtonRightBackground;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jvnet.substance.utils.SubstanceConstants;

public class CoolToggleButton
extends JToggleButton {
    private CoolButton.ButtonStyle style;
    private CoolButtonBackground bkgnd;

    public CoolToggleButton() {
        this(CoolButton.ButtonStyle.NORMAL);
    }

    public CoolToggleButton(CoolButton.ButtonStyle style) {
        this.setStyle(style);
        this.setFocusable(false);
        this.setFocusPainted(false);
    }

    public ComboFrame getComboFrame() {
        return (ComboFrame)SwingUtilities.getAncestorOfClass(ComboFrame.class, this);
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        if (icon != null) {
            if (this.style == CoolButton.ButtonStyle.NORMAL) {
                this.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            }
            BufferedImage iconImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            Graphics2D g = (Graphics2D)iconImage.getGraphics();
            icon.paintIcon(this, g, 0, 0);
            g.dispose();
            float scale = 0.5f;
            RescaleOp rop = new RescaleOp(new float[]{scale, scale, scale, scale}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
            BufferedImage image = rop.filter(iconImage, null);
            this.setDisabledIcon(new ImageIcon(image));
            super.setText(null);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (text != null) {
            super.setIcon(null);
        }
    }

    public void setStyle(CoolButton.ButtonStyle style) {
        this.style = style;
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        switch (style) {
            case NORMAL: {
                this.bkgnd = new CoolButtonNormalBackground(this);
                break;
            }
            case LEFT: {
                openSides.add(SubstanceConstants.Side.RIGHT);
                this.putClientProperty("substancelaf.buttonopenSide", openSides);
                this.bkgnd = new CoolButtonLeftBackground(this);
                break;
            }
            case CENTER: {
                openSides.add(SubstanceConstants.Side.LEFT);
                openSides.add(SubstanceConstants.Side.RIGHT);
                this.putClientProperty("substancelaf.buttonopenSide", openSides);
                this.bkgnd = new CoolButtonCenterBackground(this);
                break;
            }
            case RIGHT: {
                openSides.add(SubstanceConstants.Side.LEFT);
                this.putClientProperty("substancelaf.buttonopenSide", openSides);
                this.bkgnd = new CoolButtonRightBackground(this);
            }
        }
        Insets insets = this.bkgnd.getInsets();
        Border border = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        this.setBorder(border);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: (file)");
        }
        LookAndFeel laf = Platform.getPlatform().getLookAndFeel();
        UIManager.setLookAndFeel(laf);
        BufferedImage image = ImageIO.read(new File(args[0]));
        ImageIcon icon = new ImageIcon(image);
        CoolToggleButton button1 = new CoolToggleButton();
        button1.setIcon(icon);
        CoolToggleButton button2 = new CoolToggleButton();
        button2.setText("Some Text");
        CoolToggleButton button3 = new CoolToggleButton();
        button3.setIcon(icon);
        button3.setEnabled(false);
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        panel.setBackground(LightZoneSkin.Colors.FrameBackground);
        panel.add(button1);
        panel.add(button2);
        panel.add(button3);
        JFrame frame = new JFrame();
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

