/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.scroll;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;

public class CenteringViewportLayout
extends ViewportLayout {
    private Dimension oldSize;

    @Override
    public void layoutContainer(Container parent) {
        JViewport viewport = (JViewport)parent;
        Component view = viewport.getView();
        Dimension newSize = view.getPreferredSize();
        if (this.oldSize != null && !newSize.equals(this.oldSize)) {
            Rectangle oldVisible = viewport.getViewRect();
            Rectangle newVisible = CenteringViewportLayout.getNewVisible(this.oldSize, oldVisible, newSize);
            Point p = CenteringViewportLayout.getViewPosition(newSize, newVisible);
            super.layoutContainer(parent);
            viewport.setViewPosition(p);
            this.oldSize = newSize;
        } else {
            super.layoutContainer(parent);
        }
        this.oldSize = view.getSize();
    }

    private static Point getViewPosition(Dimension size, Rectangle visible) {
        int x = visible.x;
        int y = visible.y;
        if (x < 0) {
            x = 0;
        } else if (x > size.width - visible.width) {
            x = Math.max(0, size.width - visible.width);
        }
        if (y < 0) {
            y = 0;
        } else if (y > size.height - visible.height) {
            y = Math.max(0, size.height - visible.height);
        }
        return new Point(x, y);
    }

    private static Rectangle getNewVisible(Dimension oldSize, Rectangle oldVisible, Dimension newSize) {
        int oldCenterX = oldVisible.x + oldVisible.width / 2;
        int oldCenterY = oldVisible.y + oldVisible.height / 2;
        double x = (double)oldCenterX / (double)oldSize.width;
        double y = (double)oldCenterY / (double)oldSize.height;
        int newCenterX = (int)Math.round(x * (double)newSize.width);
        int newCenterY = (int)Math.round(y * (double)newSize.height);
        int newLeft = newCenterX - oldVisible.width / 2;
        int newTop = newCenterY - oldVisible.height / 2;
        int newWidth = oldVisible.width;
        int newHeight = oldVisible.height;
        Rectangle newVisible = new Rectangle(newLeft, newTop, newWidth, newHeight);
        return newVisible;
    }
}

