/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.print.Locale;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.print.PrintLayoutModelListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

class CenteredCheckBox
extends JCheckBox
implements PrintLayoutModelListener {
    CenteredCheckBox(final PrintLayoutModel model) {
        super(Locale.LOCALE.get("CenteredCheck"));
        boolean centered = model.isKeepCentered();
        this.setSelected(centered);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                boolean doCenter = event.getStateChange() == 1;
                model.setKeepCentered(doCenter);
            }
        });
        model.addListener(this);
    }

    @Override
    public void layoutChanged(PrintLayoutModel source) {
        boolean selected = source.isKeepCentered();
        this.setSelected(selected);
    }
}

