/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.print.Locale;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

class ButtonPanel
extends Box {
    private JButton print = new JButton(Locale.LOCALE.get("PrintButton"));
    private JButton cancel = new JButton(Locale.LOCALE.get("CancelButton"));
    private JButton done = new JButton(Locale.LOCALE.get("DoneButton"));
    private JButton setup = new JButton(Locale.LOCALE.get("SetupButton"));

    ButtonPanel() {
        super(0);
        int maxWidth = 0;
        int width = this.print.getPreferredSize().width;
        maxWidth = width > maxWidth ? width : maxWidth;
        width = this.cancel.getPreferredSize().width;
        maxWidth = width > maxWidth ? width : maxWidth;
        width = this.done.getPreferredSize().width;
        maxWidth = width > maxWidth ? width : maxWidth;
        width = this.setup.getPreferredSize().width;
        maxWidth = width > maxWidth ? width : maxWidth;
        ButtonPanel.setFixedSize(this.print, maxWidth);
        ButtonPanel.setFixedSize(this.cancel, maxWidth);
        ButtonPanel.setFixedSize(this.done, maxWidth);
        ButtonPanel.setFixedSize(this.setup, maxWidth);
        Box subBox = Box.createVerticalBox();
        subBox.add(this.print);
        subBox.add(Box.createVerticalStrut(3));
        subBox.add(this.cancel);
        subBox.add(Box.createVerticalStrut(3));
        subBox.add(this.done);
        subBox.add(Box.createVerticalStrut(3));
        subBox.add(this.setup);
        this.add(Box.createHorizontalGlue());
        this.add(subBox);
    }

    void addPrintAction(ActionListener action) {
        this.print.addActionListener(action);
    }

    void addCancelAction(ActionListener action) {
        this.cancel.addActionListener(action);
    }

    void addDoneAction(ActionListener action) {
        this.done.addActionListener(action);
    }

    void addPrintSetupAction(ActionListener action) {
        this.setup.addActionListener(action);
    }

    void doCancelActions() {
        this.cancel.doClick();
    }

    void doDoneActions() {
        this.done.doClick();
    }

    private static void setFixedSize(JButton button, int width) {
        Dimension size = button.getPreferredSize();
        size = new Dimension(width, size.height);
        button.setMinimumSize(size);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new ButtonPanel());
        JFrame frame = new JFrame("ButtonPanel Test");
        frame.setContentPane(panel);
        frame.setLocation(100, 100);
        frame.pack();
        frame.show();
    }
}

