/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.CurveTypeButtons;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.CollapseExpandAction;
import com.lightcrafts.ui.operation.CollapseExpandButton;
import com.lightcrafts.ui.operation.HelpButton;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.OpTitle;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.toolkit.IconFactory;
import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class SelectableTitle
extends JPanel
implements MouseListener {
    static final int ButtonSpace = 8;
    private static final int TitleLeftInset = 2;
    private static final int TitleRightInset = 2;
    private static final int IconSpace = 3;
    private static final float TitleFontSize = 12.0f;
    private static final Color TitleTextColor = LightZoneSkin.Colors.ToolTitleTextColor;
    SelectableControl control;
    Box buttonBox;
    JTextField label;
    private Box buttonBoxBox;
    private JButton lockButton;
    private BufferedImage icon;
    private CollapseExpandAction collapseAction;
    private CollapseExpandButton collapseButton;
    private boolean selected;
    private boolean hasRegions = false;
    private static final RenderingHints aliasingRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final String TitleTag = "Name";
    private static final String CollapsedTag = "Collapsed";

    SelectableTitle(SelectableControl control) {
        this.control = control;
        this.setLayout(null);
        this.resetTitle("Untitled");
        this.label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.collapseAction = new CollapseExpandAction(this);
        if (!control.isContentShown()) {
            this.collapseAction.setState(true);
        }
        this.collapseButton = new CollapseExpandButton(this.collapseAction);
        this.collapseButton.addMouseListener(this);
        this.lockButton = SelectableTitle.createLockButton();
        this.lockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = SelectableTitle.this.getPopupMenu();
                menu.show(SelectableTitle.this.lockButton, 0, 0);
            }
        });
        HelpButton help = new HelpButton(control);
        help.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.buttonBox = Box.createHorizontalBox();
        this.buttonBox.add(help);
        this.buttonBoxBox = Box.createHorizontalBox();
        this.buttonBoxBox.add(this.buttonBox);
        this.add(this.buttonBoxBox);
        this.add(this.collapseButton);
        this.addMouseListener(this);
    }

    void setTitleText(String s) {
        this.label.setText(s);
        this.revalidate();
    }

    String getTitleText() {
        return this.label.getText();
    }

    void setTitle(JTextField text) {
        if (this.label != null) {
            this.remove(this.label);
        }
        this.label = text;
        this.label.setOpaque(false);
        this.label.setForeground(TitleTextColor);
        Font font = SelectableTitle.getTitleFont();
        this.label.setFont(font);
        this.add(this.label);
        this.revalidate();
        this.repaint();
    }

    void resetTitle(String s) {
        JTextField newLabel = new JTextField(s);
        newLabel.setEditable(false);
        newLabel.setEnabled(false);
        newLabel.setDisabledTextColor(TitleTextColor);
        this.setTitle(newLabel);
    }

    public void setRegionIndicator(boolean hasRegions) {
        if (this.hasRegions != hasRegions) {
            this.hasRegions = hasRegions;
            this.revalidate();
            this.repaint();
        }
    }

    void setIcon(BufferedImage icon) {
        this.icon = icon;
        this.revalidate();
    }

    void setSelected(boolean selected) {
        if (selected != this.selected) {
            this.selected = selected;
            this.repaint();
        }
    }

    void addLock() {
        this.buttonBoxBox.removeAll();
        this.buttonBoxBox.add(this.lockButton);
        this.invalidate();
        this.repaint();
    }

    void removeLock() {
        this.buttonBoxBox.removeAll();
        this.buttonBoxBox.add(this.buttonBox);
        this.invalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        RenderingHints hints = g.getRenderingHints();
        g.setRenderingHints(aliasingRenderHints);
        Dimension size = this.getSize();
        JButton button = new JButton("");
        button.setSize(size.width, size.height);
        if (this.selected) {
            button.putClientProperty("substancelaf.theme", LightZoneSkin.orangeTheme);
            button.putClientProperty("substancelaf.paintactive", Boolean.TRUE);
        }
        button.paint(g);
        if (this.hasRegions) {
            Icon curveIcon = CurveTypeButtons.RegionGenericIcon;
            int iconH = curveIcon.getIconHeight();
            int iconX = 2 + this.collapseButton.getSize().width;
            int iconY = (size.height - iconH) / 2;
            curveIcon.paintIcon(this, g, iconX, iconY);
        }
        if (this.icon != null) {
            int iconH = this.icon.getHeight();
            int iconX = 2 + this.collapseButton.getSize().width + (this.hasRegions ? CurveTypeButtons.RegionGenericIcon.getIconWidth() : 0);
            int iconY = (size.height - iconH) / 2;
            g.drawImage(this.icon, iconX + 3, iconY + 3, this.icon.getWidth() - 6, this.icon.getHeight() - 6, null);
        }
        g.setRenderingHints(hints);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Dimension buttonSize = this.collapseButton.getPreferredSize();
        this.collapseButton.setLocation(2, (size.height - buttonSize.height) / 2);
        this.collapseButton.setSize(buttonSize);
        int iconW = (this.icon != null ? this.icon.getWidth() : 0) + (this.hasRegions ? CurveTypeButtons.BezierIcon.getIconWidth() : 0);
        Dimension titleSize = this.label.getPreferredSize();
        int titleX = 2 + buttonSize.width + iconW + 3;
        int titleY = (size.height - titleSize.height) / 2;
        this.label.setLocation(titleX, titleY);
        int titleW = Math.min(titleSize.width, size.width - titleX);
        int titleH = Math.min(titleSize.height, size.height);
        this.label.setSize(new Dimension(titleW, titleH));
        Dimension buttonBoxSize = this.buttonBoxBox.getPreferredSize();
        this.buttonBoxBox.setLocation(size.width - 2 - buttonBoxSize.width, (size.height - buttonBoxSize.height) / 2);
        this.buttonBoxBox.setSize(buttonBoxSize);
    }

    private static JButton createLockButton() {
        Icon normalIcon = IconFactory.invertIcon(SelectableTitle.getTitleIcon("lock"));
        Icon pressedIcon = IconFactory.invertIcon(SelectableTitle.getTitleIcon("lock_pressed"));
        return new ImageOnlyButton(normalIcon, pressedIcon);
    }

    void save(XmlNode node) {
        node.setAttribute(TitleTag, this.getTitleText());
        boolean collapsed = !this.control.isContentShown();
        node.setAttribute(CollapsedTag, Boolean.toString(collapsed));
    }

    void restore(XmlNode node) throws XMLException {
        if (node.hasAttribute(TitleTag)) {
            String text = node.getAttribute(TitleTag);
            this.setTitleText(text);
        }
        if (node.hasAttribute(CollapsedTag)) {
            String value = node.getAttribute(CollapsedTag);
            boolean collapsed = Boolean.valueOf(value);
            this.control.setShowContent(!collapsed);
            if (collapsed) {
                this.collapseAction.setState(true);
            }
        }
    }

    private static Font getTitleFont() {
        Font font = OpControl.ControlFont;
        font = font.deriveFont(1);
        font = font.deriveFont(12.0f);
        return font;
    }

    private static Image getTitleImage(String name) {
        String path = "resources/" + name + ".png";
        URL url = OpTitle.class.getResource(path);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createImage(url);
    }

    static Icon getTitleIcon(String name) {
        String path = "resources/" + name + ".png";
        URL url = OpTitle.class.getResource(path);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int count = e.getClickCount();
        if (count == 2) {
            if (!this.control.isContentShown()) {
                this.doExpand();
            } else {
                this.doCollapse();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        } else {
            OpStack stack = this.findOpStack();
            if (stack.getAutoExpand() && !this.control.isContentShown()) {
                stack.collapseAll();
                this.doExpand();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void handlePopup(MouseEvent e) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    void doExpand() {
        OpStack stack = this.findOpStack();
        stack.expand(this.control);
        this.collapseAction.setState(false);
    }

    void doCollapse() {
        OpStack stack = this.findOpStack();
        stack.collapse(this.control);
        this.collapseAction.setState(true);
    }

    JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        final OpStack stack = this.findOpStack();
        JMenuItem collapseItem = new JMenuItem(Locale.LOCALE.get("CollapseMenuItem"));
        collapseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectableTitle.this.doCollapse();
            }
        });
        JMenuItem collapseOthers = new JMenuItem(Locale.LOCALE.get("CollapseOthersMenuItem"));
        collapseOthers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stack.setAutoExpand(false);
                stack.collapseAll();
                SelectableTitle.this.doExpand();
            }
        });
        JMenuItem expandItem = new JMenuItem(Locale.LOCALE.get("ExpandMenuItem"));
        expandItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectableTitle.this.doExpand();
            }
        });
        JMenuItem autoItem = new JMenuItem(Locale.LOCALE.get("AutoExpandMenuItem"));
        autoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stack.setAutoExpand(true);
                stack.collapseAll();
                SelectableTitle.this.doExpand();
            }
        });
        JMenuItem noAutoItem = new JMenuItem(Locale.LOCALE.get("DontAutoExpandMenuItem"));
        noAutoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stack.setAutoExpand(false);
            }
        });
        JMenuItem collapseAllItem = new JMenuItem(Locale.LOCALE.get("CollapseAllMenuItem"));
        collapseAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stack.setAutoExpand(false);
                stack.collapseAll();
            }
        });
        JMenuItem expandAllItem = new JMenuItem(Locale.LOCALE.get("ExpandAllMenuItem"));
        expandAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stack.setAutoExpand(false);
                stack.expandAll();
            }
        });
        if (this.control.isContentShown()) {
            menu.add(collapseItem);
            menu.add(collapseAllItem);
            menu.add(collapseOthers);
        } else {
            menu.add(collapseAllItem);
        }
        menu.add(new JSeparator());
        menu.add(expandItem);
        menu.add(expandAllItem);
        menu.add(new JSeparator());
        if (!stack.getAutoExpand()) {
            menu.add(autoItem);
        } else {
            menu.add(noAutoItem);
        }
        return menu;
    }

    OpStack findOpStack() {
        return (OpStack)SwingUtilities.getAncestorOfClass(OpStack.class, this);
    }

    static {
        aliasingRenderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        aliasingRenderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

